/*
 * Decompiled with CFR 0.152.
 */
package no.nav.security.token.support.core.utils;

import java.util.Optional;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import no.nav.security.token.support.core.context.TokenValidationContext;
import no.nav.security.token.support.core.context.TokenValidationContextHolder;
import no.nav.security.token.support.core.jwt.JwtToken;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0012\u0010\u0004\u001a\u00020\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007H\u0007J%\u0010\b\u001a\r\u0012\t\u0012\u00070\n\u00a2\u0006\u0002\b\u000b0\t2\u0006\u0010\f\u001a\u00020\r2\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007H\u0007J\u0012\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007H\u0002\u00a8\u0006\u0010"}, d2={"Lno/nav/security/token/support/core/utils/JwtTokenUtil;", "", "<init>", "()V", "contextHasValidToken", "", "holder", "Lno/nav/security/token/support/core/context/TokenValidationContextHolder;", "getJwtToken", "Ljava/util/Optional;", "Lno/nav/security/token/support/core/jwt/JwtToken;", "Lkotlin/jvm/internal/EnhancedNullability;", "issuer", "", "context", "Lno/nav/security/token/support/core/context/TokenValidationContext;", "token-validation-core"})
public final class JwtTokenUtil {
    @NotNull
    public static final JwtTokenUtil INSTANCE = new JwtTokenUtil();

    private JwtTokenUtil() {
    }

    @JvmStatic
    public static final boolean contextHasValidToken(@Nullable TokenValidationContextHolder holder) {
        return INSTANCE.context(holder).hasValidToken();
    }

    @JvmStatic
    @NotNull
    public static final Optional<JwtToken> getJwtToken(@NotNull String issuer, @Nullable TokenValidationContextHolder holder) {
        Intrinsics.checkNotNullParameter((Object)issuer, (String)"issuer");
        return INSTANCE.context(holder).getJwtTokenAsOptional(issuer);
    }

    private final TokenValidationContext context(TokenValidationContextHolder holder) {
        Object object = holder;
        if (object == null || (object = object.getTokenValidationContext()) == null) {
            throw new IllegalStateException("TokenValidationContextHolder is null");
        }
        return object;
    }
}

