/*
 * Decompiled with CFR 0.152.
 */
package no.nav.security.token.support.core.context;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import no.nav.security.token.support.core.jwt.JwtToken;
import no.nav.security.token.support.core.jwt.JwtTokenClaims;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u001b\u0012\u0012\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0019\u0010\b\u001a\r\u0012\t\u0012\u00070\u0005\u00a2\u0006\u0002\b\n0\t2\u0006\u0010\u000b\u001a\u00020\u0004J\u0010\u0010\u000f\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u000b\u001a\u00020\u0004J\u000e\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u000b\u001a\u00020\u0004J\u0006\u0010\u0015\u001a\u00020\u0016J\u000e\u0010\u0017\u001a\u00020\u00162\u0006\u0010\u000b\u001a\u00020\u0004J\u0012\u0010\u001c\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u000b\u001a\u00020\u0004H\u0002J\b\u0010\u001d\u001a\u00020\u0004H\u0016R\u001a\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\f\u001a\u0004\u0018\u00010\u00058F\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u0013\u0010\u0012\u001a\u0004\u0018\u00010\u00118F\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014R\u0017\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00040\u00198F\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u001b\u00a8\u0006\u001e"}, d2={"Lno/nav/security/token/support/core/context/TokenValidationContext;", "", "validatedTokens", "", "", "Lno/nav/security/token/support/core/jwt/JwtToken;", "<init>", "(Ljava/util/Map;)V", "getJwtTokenAsOptional", "Ljava/util/Optional;", "Lkotlin/jvm/internal/EnhancedNullability;", "issuerName", "firstValidToken", "getFirstValidToken", "()Lno/nav/security/token/support/core/jwt/JwtToken;", "getJwtToken", "getClaims", "Lno/nav/security/token/support/core/jwt/JwtTokenClaims;", "anyValidClaims", "getAnyValidClaims", "()Lno/nav/security/token/support/core/jwt/JwtTokenClaims;", "hasValidToken", "", "hasTokenFor", "issuers", "", "getIssuers", "()Ljava/util/List;", "jwtToken", "toString", "token-validation-core"})
@SourceDebugExtension(value={"SMAP\nTokenValidationContext.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TokenValidationContext.kt\nno/nav/security/token/support/core/context/TokenValidationContext\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,30:1\n1#2:31\n1557#3:32\n1628#3,3:33\n*S KotlinDebug\n*F\n+ 1 TokenValidationContext.kt\nno/nav/security/token/support/core/context/TokenValidationContext\n*L\n17#1:32\n17#1:33,3\n*E\n"})
public final class TokenValidationContext {
    @NotNull
    private final Map<String, JwtToken> validatedTokens;

    public TokenValidationContext(@NotNull Map<String, ? extends JwtToken> validatedTokens) {
        Intrinsics.checkNotNullParameter(validatedTokens, (String)"validatedTokens");
        this.validatedTokens = validatedTokens;
    }

    @NotNull
    public final Optional<JwtToken> getJwtTokenAsOptional(@NotNull String issuerName) {
        Object object;
        block3: {
            block2: {
                Intrinsics.checkNotNullParameter((Object)issuerName, (String)"issuerName");
                object = this.jwtToken(issuerName);
                if (object == null) break block2;
                JwtToken it = object;
                boolean bl = false;
                Optional<JwtToken> optional = Optional.of(it);
                object = optional;
                if (optional != null) break block3;
            }
            Optional optional = Optional.empty();
            object = optional;
            Intrinsics.checkNotNullExpressionValue(optional, (String)"empty(...)");
        }
        return object;
    }

    @Nullable
    public final JwtToken getFirstValidToken() {
        return (JwtToken)CollectionsKt.firstOrNull((Iterable)this.validatedTokens.values());
    }

    @Nullable
    public final JwtToken getJwtToken(@NotNull String issuerName) {
        Intrinsics.checkNotNullParameter((Object)issuerName, (String)"issuerName");
        return this.jwtToken(issuerName);
    }

    @NotNull
    public final JwtTokenClaims getClaims(@NotNull String issuerName) {
        Intrinsics.checkNotNullParameter((Object)issuerName, (String)"issuerName");
        Object object = this.jwtToken(issuerName);
        if (object == null || (object = ((JwtToken)object).getJwtTokenClaims()) == null) {
            throw new IllegalArgumentException("No token found for issuer " + issuerName);
        }
        return object;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final JwtTokenClaims getAnyValidClaims() {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = this.validatedTokens.values();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void p0;
            JwtToken jwtToken = (JwtToken)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(p0.getJwtTokenClaims());
        }
        return (JwtTokenClaims)CollectionsKt.firstOrNull((List)((List)destination$iv$iv));
    }

    public final boolean hasValidToken() {
        return !this.validatedTokens.isEmpty();
    }

    public final boolean hasTokenFor(@NotNull String issuerName) {
        Intrinsics.checkNotNullParameter((Object)issuerName, (String)"issuerName");
        return this.getJwtToken(issuerName) != null;
    }

    @NotNull
    public final List<String> getIssuers() {
        return CollectionsKt.toList((Iterable)this.validatedTokens.keySet());
    }

    private final JwtToken jwtToken(String issuerName) {
        return this.validatedTokens.get(issuerName);
    }

    @NotNull
    public String toString() {
        return "TokenValidationContext{issuers=" + this.validatedTokens.keySet() + "}";
    }
}

