/*
 * Decompiled with CFR 0.152.
 */
package no.nav.security.token.support.core.jwt;

import com.nimbusds.jwt.JWT;
import com.nimbusds.jwt.JWTClaimsSet;
import com.nimbusds.jwt.JWTParser;
import com.nimbusds.jwt.SignedJWT;
import kotlin.Deprecated;
import kotlin.DeprecationLevel;
import kotlin.Metadata;
import kotlin.ReplaceWith;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import no.nav.security.token.support.core.jwt.JwtTokenClaims;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u0016\u0018\u0000 %2\u00020\u0001:\u0001%B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tB\u0011\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\b\u0010\nJ\u0006\u0010 \u001a\u00020\u0003J\u0016\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020\u00032\u0006\u0010$\u001a\u00020\u0003R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\u0004\u001a\u00020\u0005X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u001b\u0010\u0011\u001a\n \u0013*\u0004\u0018\u00010\u00120\u0012\u00a2\u0006\n\n\u0002\u0010\u0016\u001a\u0004\b\u0014\u0010\u0015R\u001b\u0010\u0017\u001a\n \u0013*\u0004\u0018\u00010\u00030\u0003\u00a2\u0006\n\n\u0002\u0010\u0019\u001a\u0004\b\u0018\u0010\fR\u001b\u0010\u001a\u001a\n \u0013*\u0004\u0018\u00010\u00030\u0003\u00a2\u0006\n\n\u0002\u0010\u0019\u001a\u0004\b\u001b\u0010\fR\u001c\u0010\u001c\u001a\u00020\u00038\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u001d\u0010\u001e\u001a\u0004\b\u001f\u0010\f\u00a8\u0006&"}, d2={"Lno/nav/security/token/support/core/jwt/JwtToken;", "", "encodedToken", "", "jwt", "Lcom/nimbusds/jwt/JWT;", "jwtTokenClaims", "Lno/nav/security/token/support/core/jwt/JwtTokenClaims;", "<init>", "(Ljava/lang/String;Lcom/nimbusds/jwt/JWT;Lno/nav/security/token/support/core/jwt/JwtTokenClaims;)V", "(Ljava/lang/String;)V", "getEncodedToken", "()Ljava/lang/String;", "getJwt", "()Lcom/nimbusds/jwt/JWT;", "getJwtTokenClaims", "()Lno/nav/security/token/support/core/jwt/JwtTokenClaims;", "jwtClaimsSet", "Lcom/nimbusds/jwt/JWTClaimsSet;", "kotlin.jvm.PlatformType", "getJwtClaimsSet", "()Lcom/nimbusds/jwt/JWTClaimsSet;", "Lcom/nimbusds/jwt/JWTClaimsSet;", "subject", "getSubject", "Ljava/lang/String;", "issuer", "getIssuer", "tokenAsString", "getTokenAsString$annotations", "()V", "getTokenAsString", "asBearer", "containsClaim", "", "name", "value", "Companion", "token-validation-core"})
public class JwtToken {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String encodedToken;
    @NotNull
    private final JWT jwt;
    @NotNull
    private final JwtTokenClaims jwtTokenClaims;
    private final JWTClaimsSet jwtClaimsSet;
    private final String subject;
    private final String issuer;
    @NotNull
    private final String tokenAsString;

    public JwtToken(@NotNull String encodedToken, @NotNull JWT jwt, @NotNull JwtTokenClaims jwtTokenClaims) {
        Intrinsics.checkNotNullParameter((Object)encodedToken, (String)"encodedToken");
        Intrinsics.checkNotNullParameter((Object)jwt, (String)"jwt");
        Intrinsics.checkNotNullParameter((Object)jwtTokenClaims, (String)"jwtTokenClaims");
        this.encodedToken = encodedToken;
        this.jwt = jwt;
        this.jwtTokenClaims = jwtTokenClaims;
        this.jwtClaimsSet = this.jwt.getJWTClaimsSet();
        this.subject = this.jwtTokenClaims.getSubject();
        this.issuer = this.jwtTokenClaims.getIssuer();
        this.tokenAsString = this.encodedToken;
    }

    @NotNull
    public final String getEncodedToken() {
        return this.encodedToken;
    }

    @NotNull
    protected final JWT getJwt() {
        return this.jwt;
    }

    @NotNull
    public final JwtTokenClaims getJwtTokenClaims() {
        return this.jwtTokenClaims;
    }

    public JwtToken(@NotNull String encodedToken) {
        Intrinsics.checkNotNullParameter((Object)encodedToken, (String)"encodedToken");
        JWT jWT = JWTParser.parse((String)encodedToken);
        Intrinsics.checkNotNullExpressionValue((Object)jWT, (String)"parse(...)");
        JWTClaimsSet jWTClaimsSet = JWTParser.parse((String)encodedToken).getJWTClaimsSet();
        Intrinsics.checkNotNullExpressionValue((Object)jWTClaimsSet, (String)"getJWTClaimsSet(...)");
        this(encodedToken, jWT, new JwtTokenClaims(jWTClaimsSet));
    }

    public final JWTClaimsSet getJwtClaimsSet() {
        return this.jwtClaimsSet;
    }

    public final String getSubject() {
        return this.subject;
    }

    public final String getIssuer() {
        return this.issuer;
    }

    @NotNull
    public final String getTokenAsString() {
        return this.tokenAsString;
    }

    @Deprecated(message="Use getEncodedToken instead", replaceWith=@ReplaceWith(expression="getEncodedToken()", imports={}), level=DeprecationLevel.WARNING)
    public static /* synthetic */ void getTokenAsString$annotations() {
    }

    @NotNull
    public final String asBearer() {
        return "Bearer " + this.encodedToken;
    }

    public final boolean containsClaim(@NotNull String name, @NotNull String value) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        return this.jwtTokenClaims.containsClaim(name, value);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\n\u0010\u0004\u001a\u00020\u0005*\u00020\u0006\u00a8\u0006\u0007"}, d2={"Lno/nav/security/token/support/core/jwt/JwtToken$Companion;", "", "<init>", "()V", "asBearer", "", "Lcom/nimbusds/jwt/SignedJWT;", "token-validation-core"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final String asBearer(@NotNull SignedJWT $this$asBearer) {
            Intrinsics.checkNotNullParameter((Object)$this$asBearer, (String)"<this>");
            return "Bearer " + $this$asBearer.serialize();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

