/*
 * Decompiled with CFR 0.152.
 */
package no.nav.security.token.support.core.validation;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmClassMappingKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KClass;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import no.nav.security.token.support.core.api.Protected;
import no.nav.security.token.support.core.api.ProtectedWithClaims;
import no.nav.security.token.support.core.api.RequiredIssuers;
import no.nav.security.token.support.core.api.Unprotected;
import no.nav.security.token.support.core.context.TokenValidationContextHolder;
import no.nav.security.token.support.core.exceptions.AnnotationRequiredException;
import no.nav.security.token.support.core.exceptions.JwtTokenInvalidClaimException;
import no.nav.security.token.support.core.exceptions.JwtTokenMissingException;
import no.nav.security.token.support.core.jwt.JwtToken;
import no.nav.security.token.support.core.utils.Cluster;
import no.nav.security.token.support.core.utils.JwtTokenUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0011\n\u0002\b\n\b\u0016\u0018\u0000 %2\u00020\u0001:\u0001%B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000e\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tJ\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u000bH\u0002J\b\u0010\f\u001a\u00020\u0007H\u0002J\u0010\u0010\r\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u000eH\u0002J\u0010\u0010\u000f\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u0010H\u0002J(\u0010\u0011\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u0012\u001a\u00020\t2\u0014\u0010\u0013\u001a\u0010\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\u000b0\u00150\u0014H\u0014J\u0018\u0010\u0016\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u000e2\u0006\u0010\u0017\u001a\u00020\u0018H\u0004J1\u0010\r\u001a\u00020\u00072\u0006\u0010\u0019\u001a\u00020\u001a2\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001a0\u001c2\u0006\u0010\u001d\u001a\u00020\u00072\u0006\u0010\u0017\u001a\u00020\u0018\u00a2\u0006\u0002\u0010\u001eJ1\u0010\u001f\u001a\u00020\u00072\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u001d\u001a\u00020\u00072\u0012\u0010 \u001a\n\u0012\u0006\b\u0001\u0012\u00020\u001a0\u001c\"\u00020\u001aH\u0004\u00a2\u0006\u0002\u0010!J)\u0010\"\u001a\u00020\u00072\u0006\u0010\u0017\u001a\u00020\u00182\u0012\u0010 \u001a\n\u0012\u0006\b\u0001\u0012\u00020\u001a0\u001c\"\u00020\u001aH\u0002\u00a2\u0006\u0002\u0010#J)\u0010$\u001a\u00020\u00072\u0006\u0010\u0017\u001a\u00020\u00182\u0012\u0010 \u001a\n\u0012\u0006\b\u0001\u0012\u00020\u001a0\u001c\"\u00020\u001aH\u0002\u00a2\u0006\u0002\u0010#R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006&"}, d2={"Lno/nav/security/token/support/core/validation/JwtTokenAnnotationHandler;", "", "tokenValidationContextHolder", "Lno/nav/security/token/support/core/context/TokenValidationContextHolder;", "<init>", "(Lno/nav/security/token/support/core/context/TokenValidationContextHolder;)V", "assertValidAnnotation", "", "m", "Ljava/lang/reflect/Method;", "a", "", "handleProtected", "handleProtectedWithClaims", "Lno/nav/security/token/support/core/api/ProtectedWithClaims;", "handleRequiredIssuers", "Lno/nav/security/token/support/core/api/RequiredIssuers;", "getAnnotation", "method", "types", "", "Lkotlin/reflect/KClass;", "handleProtectedWithClaimsAnnotation", "jwtToken", "Lno/nav/security/token/support/core/jwt/JwtToken;", "issuer", "", "requiredClaims", "", "combineWithOr", "(Ljava/lang/String;[Ljava/lang/String;ZLno/nav/security/token/support/core/jwt/JwtToken;)Z", "containsRequiredClaims", "claims", "(Lno/nav/security/token/support/core/jwt/JwtToken;Z[Ljava/lang/String;)Z", "containsAllClaims", "(Lno/nav/security/token/support/core/jwt/JwtToken;[Ljava/lang/String;)Z", "containsAnyClaim", "Companion", "token-validation-core"})
@SourceDebugExtension(value={"SMAP\nJwtTokenAnnotationHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JwtTokenAnnotationHandler.kt\nno/nav/security/token/support/core/validation/JwtTokenAnnotationHandler\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 4 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,114:1\n1#2:115\n12511#3,2:116\n12308#3,2:118\n1228#4,2:120\n1251#4,2:122\n*S KotlinDebug\n*F\n+ 1 JwtTokenAnnotationHandler.kt\nno/nav/security/token/support/core/validation/JwtTokenAnnotationHandler\n*L\n60#1:116,2\n66#1:118,2\n94#1:120,2\n103#1:122,2\n*E\n"})
public class JwtTokenAnnotationHandler {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final TokenValidationContextHolder tokenValidationContextHolder;
    @JvmField
    @NotNull
    public static final List<KClass<? extends Annotation>> SUPPORTED_ANNOTATIONS;
    @NotNull
    private static final Logger LOG;

    public JwtTokenAnnotationHandler(@NotNull TokenValidationContextHolder tokenValidationContextHolder) {
        Intrinsics.checkNotNullParameter((Object)tokenValidationContextHolder, (String)"tokenValidationContextHolder");
        this.tokenValidationContextHolder = tokenValidationContextHolder;
    }

    public final boolean assertValidAnnotation(@NotNull Method m) {
        Intrinsics.checkNotNullParameter((Object)m, (String)"m");
        Annotation annotation = this.getAnnotation(m, SUPPORTED_ANNOTATIONS);
        if (annotation == null) {
            throw new AnnotationRequiredException(m);
        }
        Annotation it = annotation;
        boolean bl = false;
        return this.assertValidAnnotation(it);
    }

    private final boolean assertValidAnnotation(Annotation a) {
        boolean bl;
        Annotation annotation = a;
        if (annotation instanceof Unprotected) {
            boolean bl2;
            boolean it = bl2 = true;
            boolean bl3 = false;
            LOG.debug("Annotation is of type={}, no token validation performed.", (Object)Unprotected.class.getSimpleName());
            bl = bl2;
        } else if (annotation instanceof RequiredIssuers) {
            bl = this.handleRequiredIssuers((RequiredIssuers)a);
        } else if (annotation instanceof ProtectedWithClaims) {
            bl = this.handleProtectedWithClaims((ProtectedWithClaims)a);
        } else if (annotation instanceof Protected) {
            bl = this.handleProtected();
        } else {
            boolean bl4;
            boolean it = bl4 = false;
            boolean bl5 = false;
            LOG.debug("Annotation is unknown, type={}, no token validation performed. but possible bug so throw exception", (Object)JvmClassMappingKt.getAnnotationClass((Annotation)a));
            bl = bl4;
        }
        return bl;
    }

    private final boolean handleProtected() {
        boolean bl;
        if (!JwtTokenUtil.contextHasValidToken(this.tokenValidationContextHolder)) {
            throw new JwtTokenMissingException(null, 1, null);
        }
        boolean it = bl = true;
        boolean bl2 = false;
        LOG.debug("Annotation is of type Protected, context has valid token.");
        return bl;
    }

    private final boolean handleProtectedWithClaims(ProtectedWithClaims a) {
        if (!Cluster.Companion.isProd() && ArraysKt.contains((Object[])a.excludedClusters(), (Object)((Object)Cluster.Companion.currentCluster()))) {
            LOG.info("Excluding current cluster {} from validation", (Object)Cluster.Companion.currentCluster());
            return true;
        }
        LOG.debug("Annotation is of type={}, do token validation and claim checking.", (Object)Reflection.getOrCreateKotlinClass(ProtectedWithClaims.class).getSimpleName());
        Optional<JwtToken> $this$handleProtectedWithClaims_u24lambda_u244 = JwtTokenUtil.getJwtToken(a.issuer(), this.tokenValidationContextHolder);
        boolean bl = false;
        if ($this$handleProtectedWithClaims_u24lambda_u244.isEmpty()) {
            throw new JwtTokenMissingException(null, 1, null);
        }
        JwtToken jwtToken = $this$handleProtectedWithClaims_u24lambda_u244.get();
        Intrinsics.checkNotNullExpressionValue((Object)jwtToken, (String)"get(...)");
        if (!this.handleProtectedWithClaimsAnnotation(a, jwtToken)) {
            throw new JwtTokenInvalidClaimException(a);
        }
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean handleRequiredIssuers(RequiredIssuers a) {
        boolean bl;
        block4: {
            ProtectedWithClaims element$iv;
            int n;
            ProtectedWithClaims[] $this$any$iv = a.value();
            boolean $i$f$any = false;
            int n2 = $this$any$iv.length;
            for (n = 0; n < n2; ++n) {
                ProtectedWithClaims sub = element$iv = $this$any$iv[n];
                boolean bl2 = false;
                Optional<JwtToken> jwtToken = JwtTokenUtil.getJwtToken(sub.issuer(), this.tokenValidationContextHolder);
                if (jwtToken.isPresent()) {
                    JwtToken jwtToken2 = jwtToken.get();
                    Intrinsics.checkNotNullExpressionValue((Object)jwtToken2, (String)"get(...)");
                    if (this.handleProtectedWithClaimsAnnotation(sub, jwtToken2)) {
                        return true;
                    }
                }
                boolean bl3 = false;
                if (!bl3) continue;
                return true;
            }
            boolean bl4 = false;
            boolean hasToken = bl4;
            if (hasToken) return true;
            ProtectedWithClaims[] $this$all$iv = a.value();
            boolean $i$f$all = false;
            n2 = $this$all$iv.length;
            for (n = 0; n < n2; ++n) {
                ProtectedWithClaims it = element$iv = $this$all$iv[n];
                boolean bl5 = false;
                if (JwtTokenUtil.getJwtToken(it.issuer(), this.tokenValidationContextHolder).isEmpty()) continue;
                bl = false;
                break block4;
            }
            bl = true;
        }
        if (!bl) throw new JwtTokenInvalidClaimException(a);
        throw new JwtTokenMissingException(a);
    }

    @Nullable
    protected Annotation getAnnotation(@NotNull Method method, @NotNull List<? extends KClass<? extends Annotation>> types) {
        Intrinsics.checkNotNullParameter((Object)method, (String)"method");
        Intrinsics.checkNotNullParameter(types, (String)"types");
        Annotation[] annotationArray = method.getAnnotations();
        Annotation annotation = JwtTokenAnnotationHandler.Companion.findAnnotation(types, Arrays.copyOf(annotationArray, annotationArray.length));
        if (annotation == null) {
            annotationArray = method.getDeclaringClass().getAnnotations();
            annotation = JwtTokenAnnotationHandler.Companion.findAnnotation(types, Arrays.copyOf(annotationArray, annotationArray.length));
        }
        return annotation;
    }

    protected final boolean handleProtectedWithClaimsAnnotation(@NotNull ProtectedWithClaims a, @NotNull JwtToken jwtToken) {
        Intrinsics.checkNotNullParameter((Object)a, (String)"a");
        Intrinsics.checkNotNullParameter((Object)jwtToken, (String)"jwtToken");
        return this.handleProtectedWithClaims(a.issuer(), a.claimMap(), a.combineWithOr(), jwtToken);
    }

    public final boolean handleProtectedWithClaims(@NotNull String issuer, @NotNull String[] requiredClaims, boolean combineWithOr, @NotNull JwtToken jwtToken) {
        Intrinsics.checkNotNullParameter((Object)issuer, (String)"issuer");
        Intrinsics.checkNotNullParameter((Object)requiredClaims, (String)"requiredClaims");
        Intrinsics.checkNotNullParameter((Object)jwtToken, (String)"jwtToken");
        return ((CharSequence)issuer).length() > 0 ? this.containsRequiredClaims(jwtToken, combineWithOr, Arrays.copyOf(requiredClaims, requiredClaims.length)) : true;
    }

    protected final boolean containsRequiredClaims(@NotNull JwtToken jwtToken, boolean combineWithOr, String ... claims) {
        Intrinsics.checkNotNullParameter((Object)jwtToken, (String)"jwtToken");
        Intrinsics.checkNotNullParameter((Object)claims, (String)"claims");
        LOG.debug("choose matching logic based on combineWithOr={}", (Object)combineWithOr);
        return combineWithOr ? this.containsAnyClaim(jwtToken, Arrays.copyOf(claims, claims.length)) : this.containsAllClaims(jwtToken, Arrays.copyOf(claims, claims.length));
    }

    private final boolean containsAllClaims(JwtToken jwtToken, String ... claims) {
        boolean bl;
        block3: {
            if (!(claims.length == 0)) {
                Sequence $this$all$iv = SequencesKt.filter((Sequence)SequencesKt.map((Sequence)ArraysKt.asSequence((Object[])claims), JwtTokenAnnotationHandler::containsAllClaims$lambda$7), JwtTokenAnnotationHandler::containsAllClaims$lambda$8);
                boolean $i$f$all = false;
                for (Object element$iv : $this$all$iv) {
                    List list = (List)element$iv;
                    boolean bl2 = false;
                    String key = (String)list.get(0);
                    String value = (String)list.get(1);
                    if (jwtToken.containsClaim(((Object)StringsKt.trim((CharSequence)key)).toString(), ((Object)StringsKt.trim((CharSequence)value)).toString())) continue;
                    bl = false;
                    break block3;
                }
                bl = true;
            } else {
                bl = true;
            }
        }
        return bl;
    }

    private final boolean containsAnyClaim(JwtToken jwtToken, String ... claims) {
        boolean bl;
        block3: {
            if (!(claims.length == 0)) {
                Sequence $this$any$iv = SequencesKt.filter((Sequence)SequencesKt.map((Sequence)ArraysKt.asSequence((Object[])claims), JwtTokenAnnotationHandler::containsAnyClaim$lambda$10), JwtTokenAnnotationHandler::containsAnyClaim$lambda$11);
                boolean $i$f$any = false;
                for (Object element$iv : $this$any$iv) {
                    List list = (List)element$iv;
                    boolean bl2 = false;
                    String key = (String)list.get(0);
                    String value = (String)list.get(1);
                    if (!jwtToken.containsClaim(((Object)StringsKt.trim((CharSequence)key)).toString(), ((Object)StringsKt.trim((CharSequence)value)).toString())) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            } else {
                boolean bl3;
                boolean it = bl3 = true;
                boolean bl4 = false;
                LOG.debug("no claims listed, so claim checking is ok.");
                bl = bl3;
            }
        }
        return bl;
    }

    private static final List containsAllClaims$lambda$7(String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        String[] stringArray = new String[]{"="};
        return StringsKt.split$default((CharSequence)it, (String[])stringArray, (boolean)false, (int)2, (int)2, null);
    }

    private static final boolean containsAllClaims$lambda$8(List it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.size() == 2;
    }

    private static final List containsAnyClaim$lambda$10(String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        String[] stringArray = new String[]{"="};
        return StringsKt.split$default((CharSequence)it, (String[])stringArray, (boolean)false, (int)2, (int)2, null);
    }

    private static final boolean containsAnyClaim$lambda$11(List it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.size() == 2;
    }

    static {
        Object[] objectArray = new KClass[]{Reflection.getOrCreateKotlinClass(RequiredIssuers.class), Reflection.getOrCreateKotlinClass(ProtectedWithClaims.class), Reflection.getOrCreateKotlinClass(Protected.class), Reflection.getOrCreateKotlinClass(Unprotected.class)};
        SUPPORTED_ANNOTATIONS = CollectionsKt.listOf((Object[])objectArray);
        Logger logger = LoggerFactory.getLogger(JwtTokenAnnotationHandler.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(...)");
        LOG = logger;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0010\u001b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0011\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J9\u0010\f\u001a\u0004\u0018\u00010\u00072\u0014\u0010\r\u001a\u0010\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\u00070\u00060\u00052\u0012\u0010\u000e\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00070\u000f\"\u00020\u0007H\u0002\u00a2\u0006\u0002\u0010\u0010R\u001e\u0010\u0004\u001a\u0010\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\u00070\u00060\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\u00020\tX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0011"}, d2={"Lno/nav/security/token/support/core/validation/JwtTokenAnnotationHandler$Companion;", "", "<init>", "()V", "SUPPORTED_ANNOTATIONS", "", "Lkotlin/reflect/KClass;", "", "LOG", "Lorg/slf4j/Logger;", "getLOG", "()Lorg/slf4j/Logger;", "findAnnotation", "types", "annotations", "", "(Ljava/util/List;[Ljava/lang/annotation/Annotation;)Ljava/lang/annotation/Annotation;", "token-validation-core"})
    @SourceDebugExtension(value={"SMAP\nJwtTokenAnnotationHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JwtTokenAnnotationHandler.kt\nno/nav/security/token/support/core/validation/JwtTokenAnnotationHandler$Companion\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,114:1\n1310#2,2:115\n*S KotlinDebug\n*F\n+ 1 JwtTokenAnnotationHandler.kt\nno/nav/security/token/support/core/validation/JwtTokenAnnotationHandler$Companion\n*L\n112#1:115,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        protected final Logger getLOG() {
            return LOG;
        }

        private final Annotation findAnnotation(List<? extends KClass<? extends Annotation>> types, Annotation ... annotations) {
            Annotation annotation;
            block1: {
                Annotation[] $this$firstOrNull$iv = annotations;
                boolean $i$f$firstOrNull = false;
                int n = $this$firstOrNull$iv.length;
                for (int i = 0; i < n; ++i) {
                    Annotation element$iv;
                    Annotation a = element$iv = $this$firstOrNull$iv[i];
                    boolean bl = false;
                    if (!types.contains(JvmClassMappingKt.getAnnotationClass((Annotation)a))) continue;
                    annotation = element$iv;
                    break block1;
                }
                annotation = null;
            }
            return annotation;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

