/*
 * Decompiled with CFR 0.152.
 */
package no.nav.security.token.support.core.validation;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import no.nav.security.token.support.core.configuration.IssuerConfiguration;
import no.nav.security.token.support.core.configuration.MultiIssuerConfiguration;
import no.nav.security.token.support.core.http.HttpRequest;
import no.nav.security.token.support.core.jwt.JwtToken;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001e\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0007J\u001e\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u001c\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00070\t2\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00070\tH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lno/nav/security/token/support/core/validation/JwtTokenRetriever;", "", "<init>", "()V", "LOG", "Lorg/slf4j/Logger;", "BEARER", "", "retrieveUnvalidatedTokens", "", "Lno/nav/security/token/support/core/jwt/JwtToken;", "config", "Lno/nav/security/token/support/core/configuration/MultiIssuerConfiguration;", "request", "Lno/nav/security/token/support/core/http/HttpRequest;", "getTokensFromHeader", "extractBearerTokens", "headerValues", "token-validation-core"})
@SourceDebugExtension(value={"SMAP\nJwtTokenRetriever.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JwtTokenRetriever.kt\nno/nav/security/token/support/core/validation/JwtTokenRetriever\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,41:1\n295#2,2:42\n1557#2:45\n1628#2,3:46\n827#2:49\n855#2,2:50\n1557#2:52\n1628#2,3:53\n774#2:56\n865#2,2:57\n1557#2:59\n1628#2,3:60\n1#3:44\n*S KotlinDebug\n*F\n+ 1 JwtTokenRetriever.kt\nno/nav/security/token/support/core/validation/JwtTokenRetriever\n*L\n21#1:42,2\n25#1:45\n25#1:46,3\n26#1:49\n26#1:50,2\n38#1:52\n38#1:53,3\n39#1:56\n39#1:57,2\n40#1:59\n40#1:60,3\n*E\n"})
public final class JwtTokenRetriever {
    @NotNull
    public static final JwtTokenRetriever INSTANCE = new JwtTokenRetriever();
    @NotNull
    private static final Logger LOG;
    @NotNull
    private static final String BEARER = "Bearer";

    private JwtTokenRetriever() {
    }

    @JvmStatic
    @NotNull
    public static final List<JwtToken> retrieveUnvalidatedTokens(@NotNull MultiIssuerConfiguration config, @NotNull HttpRequest request) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        return INSTANCE.getTokensFromHeader(config, request);
    }

    /*
     * WARNING - void declaration
     */
    private final List<JwtToken> getTokensFromHeader(MultiIssuerConfiguration config, HttpRequest request) {
        List list;
        try {
            List list2;
            Object v0;
            Iterable $this$firstOrNull$iv;
            block8: {
                LOG.debug("Checking authorization header for tokens using config {}", (Object)config);
                $this$firstOrNull$iv = config.getIssuers().values();
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    IssuerConfiguration it = (IssuerConfiguration)element$iv;
                    boolean bl = false;
                    if (!(request.getHeader(it.getHeaderName()) != null)) continue;
                    v0 = element$iv;
                    break block8;
                }
                v0 = null;
            }
            IssuerConfiguration it = v0;
            boolean bl2 = false;
            Optional<IssuerConfiguration> optional = Optional.ofNullable(it);
            Intrinsics.checkNotNullExpressionValue(optional, (String)"let(...)");
            Optional<IssuerConfiguration> issuer = optional;
            if (issuer.isPresent()) {
                void $this$filterNotTo$iv$iv;
                void $this$filterNot$iv;
                void $this$mapTo$iv$iv;
                Iterable $this$map$iv;
                Object object = request.getHeader(issuer.get().getHeaderName());
                if (object == null || (object = StringsKt.split$default((CharSequence)((CharSequence)object), (String[])(bl2 = new String[]{","}), (boolean)false, (int)0, (int)6, null)) == null) {
                    object = CollectionsKt.emptyList();
                }
                headerValues = object;
                $this$firstOrNull$iv = this.extractBearerTokens((List<String>)headerValues);
                boolean $i$f$map = false;
                void bl2 = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void p0;
                    String string = (String)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl3 = false;
                    collection.add(new JwtToken((String)p0));
                }
                $this$map$iv = (List)destination$iv$iv;
                boolean $i$f$filterNot = false;
                $this$mapTo$iv$iv = $this$filterNot$iv;
                destination$iv$iv = new ArrayList();
                boolean $i$f$filterNotTo = false;
                for (Object element$iv$iv : $this$filterNotTo$iv$iv) {
                    JwtToken it2 = (JwtToken)element$iv$iv;
                    boolean bl4 = false;
                    if (config.getIssuers().get(it2.getIssuer()) == null) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                list2 = (List)destination$iv$iv;
            } else {
                headerValues = CollectionsKt.emptyList();
                List it3 = headerValues;
                boolean bl5 = false;
                LOG.debug("No tokens found in authorization header");
                list2 = headerValues;
            }
            list = list2;
        }
        catch (Exception e) {
            List list3;
            List it = list3 = CollectionsKt.emptyList();
            boolean bl = false;
            LOG.warn("Received exception when attempting to extract and parse token from Authorization header", (Throwable)e);
            list = list3;
        }
        return list;
    }

    private final List<String> extractBearerTokens(List<String> headerValues) {
        Iterable $this$filterTo$iv$iv;
        List it;
        Collection collection;
        Iterable $this$mapTo$iv$iv;
        Iterable $this$map$iv = headerValues;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            String string = (String)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            String[] stringArray = new String[]{" "};
            collection.add(StringsKt.split$default((CharSequence)((CharSequence)((Object)it)), (String[])stringArray, (boolean)false, (int)0, (int)6, null));
        }
        Iterable $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$filter = false;
        $this$mapTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (List)element$iv$iv;
            boolean bl = false;
            if (!(it.size() == 2 && StringsKt.equals((String)((String)it.get(0)), (String)BEARER, (boolean)true))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$map$iv = (List)destination$iv$iv;
        $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (List)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(((Object)StringsKt.trim((CharSequence)((String)it.get(1)))).toString());
        }
        return (List)destination$iv$iv;
    }

    static {
        Logger logger = LoggerFactory.getLogger(JwtTokenRetriever.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(...)");
        LOG = logger;
    }
}

