/*
 * Decompiled with CFR 0.152.
 */
package no.nav.security.token.support.core.validation;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmClassMappingKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KClass;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import no.nav.security.token.support.core.api.Protected;
import no.nav.security.token.support.core.api.ProtectedWithClaims;
import no.nav.security.token.support.core.api.RequiredIssuers;
import no.nav.security.token.support.core.api.Unprotected;
import no.nav.security.token.support.core.context.TokenValidationContextHolder;
import no.nav.security.token.support.core.exceptions.AnnotationRequiredException;
import no.nav.security.token.support.core.exceptions.JwtTokenInvalidClaimException;
import no.nav.security.token.support.core.exceptions.JwtTokenMissingException;
import no.nav.security.token.support.core.jwt.JwtToken;
import no.nav.security.token.support.core.utils.Cluster;
import no.nav.security.token.support.core.utils.JwtTokenUtil;
import no.nav.security.token.support.core.validation.JwtTokenAnnotationHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0016\u0018\u0000 $2\u00020\u0001:\u0001$B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bJ\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\nH\u0002J)\u0010\u000b\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\r2\u0012\u0010\u000e\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00100\u000f\"\u00020\u0010H\u0002\u00a2\u0006\u0002\u0010\u0011J)\u0010\u0012\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\r2\u0012\u0010\u000e\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00100\u000f\"\u00020\u0010H\u0002\u00a2\u0006\u0002\u0010\u0011J1\u0010\u0013\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0014\u001a\u00020\u00062\u0012\u0010\u000e\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00100\u000f\"\u00020\u0010H\u0004\u00a2\u0006\u0002\u0010\u0015J(\u0010\u0016\u001a\u0004\u0018\u00010\n2\u0006\u0010\u0017\u001a\u00020\b2\u0014\u0010\u0018\u001a\u0010\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\n0\u001a0\u0019H\u0014J\b\u0010\u001b\u001a\u00020\u0006H\u0002J1\u0010\u001c\u001a\u00020\u00062\u0006\u0010\u001d\u001a\u00020\u00102\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f2\u0006\u0010\u0014\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\r\u00a2\u0006\u0002\u0010\u001fJ\u0010\u0010\u001c\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020 H\u0002J\u0018\u0010!\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020 2\u0006\u0010\f\u001a\u00020\rH\u0004J\u0010\u0010\"\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020#H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006%"}, d2={"Lno/nav/security/token/support/core/validation/JwtTokenAnnotationHandler;", "", "tokenValidationContextHolder", "Lno/nav/security/token/support/core/context/TokenValidationContextHolder;", "(Lno/nav/security/token/support/core/context/TokenValidationContextHolder;)V", "assertValidAnnotation", "", "m", "Ljava/lang/reflect/Method;", "a", "", "containsAllClaims", "jwtToken", "Lno/nav/security/token/support/core/jwt/JwtToken;", "claims", "", "", "(Lno/nav/security/token/support/core/jwt/JwtToken;[Ljava/lang/String;)Z", "containsAnyClaim", "containsRequiredClaims", "combineWithOr", "(Lno/nav/security/token/support/core/jwt/JwtToken;Z[Ljava/lang/String;)Z", "getAnnotation", "method", "types", "", "Lkotlin/reflect/KClass;", "handleProtected", "handleProtectedWithClaims", "issuer", "requiredClaims", "(Ljava/lang/String;[Ljava/lang/String;ZLno/nav/security/token/support/core/jwt/JwtToken;)Z", "Lno/nav/security/token/support/core/api/ProtectedWithClaims;", "handleProtectedWithClaimsAnnotation", "handleRequiredIssuers", "Lno/nav/security/token/support/core/api/RequiredIssuers;", "Companion", "token-validation-core"})
@SourceDebugExtension(value={"SMAP\nJwtTokenAnnotationHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JwtTokenAnnotationHandler.kt\nno/nav/security/token/support/core/validation/JwtTokenAnnotationHandler\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 4 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,115:1\n1#2:116\n12474#3,2:117\n12271#3,2:119\n1224#4,2:121\n1247#4,2:123\n*S KotlinDebug\n*F\n+ 1 JwtTokenAnnotationHandler.kt\nno/nav/security/token/support/core/validation/JwtTokenAnnotationHandler\n*L\n60#1:117,2\n67#1:119,2\n95#1:121,2\n104#1:123,2\n*E\n"})
public class JwtTokenAnnotationHandler {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final TokenValidationContextHolder tokenValidationContextHolder;
    @JvmField
    @NotNull
    public static final List<KClass<? extends Annotation>> SUPPORTED_ANNOTATIONS;
    @NotNull
    private static final Logger LOG;

    public JwtTokenAnnotationHandler(@NotNull TokenValidationContextHolder tokenValidationContextHolder) {
        Intrinsics.checkNotNullParameter((Object)tokenValidationContextHolder, (String)"tokenValidationContextHolder");
        this.tokenValidationContextHolder = tokenValidationContextHolder;
    }

    public final boolean assertValidAnnotation(@NotNull Method m) {
        Intrinsics.checkNotNullParameter((Object)m, (String)"m");
        Annotation annotation = this.getAnnotation(m, SUPPORTED_ANNOTATIONS);
        if (annotation == null) {
            throw new AnnotationRequiredException(m);
        }
        Annotation it = annotation;
        boolean bl = false;
        return this.assertValidAnnotation(it);
    }

    private final boolean assertValidAnnotation(Annotation a) {
        boolean bl;
        Annotation annotation = a;
        if (annotation instanceof Unprotected) {
            boolean bl2;
            boolean it = bl2 = true;
            boolean bl3 = false;
            LOG.debug("Annotation is of type={}, no token validation performed.", (Object)Unprotected.class.getSimpleName());
            bl = bl2;
        } else if (annotation instanceof RequiredIssuers) {
            bl = this.handleRequiredIssuers((RequiredIssuers)a);
        } else if (annotation instanceof ProtectedWithClaims) {
            bl = this.handleProtectedWithClaims((ProtectedWithClaims)a);
        } else if (annotation instanceof Protected) {
            bl = this.handleProtected();
        } else {
            boolean bl4;
            boolean it = bl4 = false;
            boolean bl5 = false;
            LOG.debug("Annotation is unknown, type={}, no token validation performed. but possible bug so throw exception", (Object)JvmClassMappingKt.getAnnotationClass((Annotation)a));
            bl = bl4;
        }
        return bl;
    }

    private final boolean handleProtected() {
        boolean bl;
        if (!JwtTokenUtil.contextHasValidToken(this.tokenValidationContextHolder)) {
            throw new JwtTokenMissingException(null, 1, null);
        }
        boolean it = bl = true;
        boolean bl2 = false;
        LOG.debug("Annotation is of type Protected, context has valid token.");
        return bl;
    }

    private final boolean handleProtectedWithClaims(ProtectedWithClaims a) {
        if (!Cluster.Companion.isProd() && ArraysKt.contains((Object[])a.excludedClusters(), (Object)((Object)Cluster.Companion.currentCluster()))) {
            LOG.info("Excluding current cluster {} from validation", (Object)Cluster.Companion.currentCluster());
            return true;
        }
        LOG.debug("Annotation is of type={}, do token validation and claim checking.", (Object)Reflection.getOrCreateKotlinClass(ProtectedWithClaims.class).getSimpleName());
        Optional<JwtToken> $this$handleProtectedWithClaims_u24lambda_u244 = JwtTokenUtil.getJwtToken(a.issuer(), this.tokenValidationContextHolder);
        boolean bl = false;
        if ($this$handleProtectedWithClaims_u24lambda_u244.isEmpty()) {
            throw new JwtTokenMissingException(null, 1, null);
        }
        JwtToken jwtToken = $this$handleProtectedWithClaims_u24lambda_u244.get();
        Intrinsics.checkNotNullExpressionValue((Object)jwtToken, (String)"get(...)");
        if (!this.handleProtectedWithClaimsAnnotation(a, jwtToken)) {
            throw new JwtTokenInvalidClaimException(a);
        }
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean handleRequiredIssuers(RequiredIssuers a) {
        boolean bl;
        block4: {
            ProtectedWithClaims it;
            ProtectedWithClaims element$iv;
            int n;
            ProtectedWithClaims[] $this$any$iv = a.value();
            boolean $i$f$any = false;
            int n2 = $this$any$iv.length;
            for (n = 0; n < n2; ++n) {
                it = element$iv = $this$any$iv[n];
                boolean bl2 = false;
                Optional<JwtToken> $this$handleRequiredIssuers_u24lambda_u246_u24lambda_u245 = JwtTokenUtil.getJwtToken(it.issuer(), this.tokenValidationContextHolder);
                boolean bl3 = false;
                if ($this$handleRequiredIssuers_u24lambda_u246_u24lambda_u245.isPresent()) {
                    JwtToken jwtToken = $this$handleRequiredIssuers_u24lambda_u246_u24lambda_u245.get();
                    Intrinsics.checkNotNullExpressionValue((Object)jwtToken, (String)"get(...)");
                    if (this.handleProtectedWithClaimsAnnotation(it, jwtToken)) {
                        return true;
                    }
                }
                boolean bl4 = false;
                if (!bl4) continue;
                return true;
            }
            boolean bl5 = false;
            boolean hasToken = bl5;
            if (hasToken) return true;
            ProtectedWithClaims[] $this$all$iv = a.value();
            boolean $i$f$all = false;
            n2 = $this$all$iv.length;
            for (n = 0; n < n2; ++n) {
                it = element$iv = $this$all$iv[n];
                boolean bl6 = false;
                if (JwtTokenUtil.getJwtToken(it.issuer(), this.tokenValidationContextHolder).isEmpty()) continue;
                bl = false;
                break block4;
            }
            bl = true;
        }
        if (!bl) throw new JwtTokenInvalidClaimException(a);
        throw new JwtTokenMissingException(a);
    }

    @Nullable
    protected Annotation getAnnotation(@NotNull Method method, @NotNull List<? extends KClass<? extends Annotation>> types) {
        Intrinsics.checkNotNullParameter((Object)method, (String)"method");
        Intrinsics.checkNotNullParameter(types, (String)"types");
        Annotation[] annotationArray = method.getAnnotations();
        Intrinsics.checkNotNullExpressionValue((Object)annotationArray, (String)"getAnnotations(...)");
        Annotation[] annotationArray2 = annotationArray;
        Annotation annotation = JwtTokenAnnotationHandler.Companion.findAnnotation(types, Arrays.copyOf(annotationArray2, annotationArray2.length));
        if (annotation == null) {
            Annotation[] annotationArray3 = method.getDeclaringClass().getAnnotations();
            Intrinsics.checkNotNullExpressionValue((Object)annotationArray3, (String)"getAnnotations(...)");
            annotationArray2 = annotationArray3;
            annotation = JwtTokenAnnotationHandler.Companion.findAnnotation(types, Arrays.copyOf(annotationArray2, annotationArray2.length));
        }
        return annotation;
    }

    protected final boolean handleProtectedWithClaimsAnnotation(@NotNull ProtectedWithClaims a, @NotNull JwtToken jwtToken) {
        Intrinsics.checkNotNullParameter((Object)a, (String)"a");
        Intrinsics.checkNotNullParameter((Object)jwtToken, (String)"jwtToken");
        return this.handleProtectedWithClaims(a.issuer(), a.claimMap(), a.combineWithOr(), jwtToken);
    }

    public final boolean handleProtectedWithClaims(@NotNull String issuer, @NotNull String[] requiredClaims, boolean combineWithOr, @NotNull JwtToken jwtToken) {
        Intrinsics.checkNotNullParameter((Object)issuer, (String)"issuer");
        Intrinsics.checkNotNullParameter((Object)requiredClaims, (String)"requiredClaims");
        Intrinsics.checkNotNullParameter((Object)jwtToken, (String)"jwtToken");
        return ((CharSequence)issuer).length() > 0 ? this.containsRequiredClaims(jwtToken, combineWithOr, Arrays.copyOf(requiredClaims, requiredClaims.length)) : true;
    }

    protected final boolean containsRequiredClaims(@NotNull JwtToken jwtToken, boolean combineWithOr, String ... claims) {
        Intrinsics.checkNotNullParameter((Object)jwtToken, (String)"jwtToken");
        Intrinsics.checkNotNullParameter((Object)claims, (String)"claims");
        LOG.debug("choose matching logic based on combineWithOr={}", (Object)combineWithOr);
        return combineWithOr ? this.containsAnyClaim(jwtToken, Arrays.copyOf(claims, claims.length)) : this.containsAllClaims(jwtToken, Arrays.copyOf(claims, claims.length));
    }

    private final boolean containsAllClaims(JwtToken jwtToken, String ... claims) {
        boolean bl;
        block3: {
            if (!(claims.length == 0)) {
                Sequence $this$all$iv = SequencesKt.filter((Sequence)SequencesKt.map((Sequence)ArraysKt.asSequence((Object[])claims), (Function1)containsAllClaims.1.INSTANCE), (Function1)containsAllClaims.2.INSTANCE);
                boolean $i$f$all = false;
                for (Object element$iv : $this$all$iv) {
                    List list = (List)element$iv;
                    boolean bl2 = false;
                    String key = (String)list.get(0);
                    String value = (String)list.get(1);
                    if (jwtToken.containsClaim(((Object)StringsKt.trim((CharSequence)key)).toString(), ((Object)StringsKt.trim((CharSequence)value)).toString())) continue;
                    bl = false;
                    break block3;
                }
                bl = true;
            } else {
                bl = true;
            }
        }
        return bl;
    }

    private final boolean containsAnyClaim(JwtToken jwtToken, String ... claims) {
        boolean bl;
        block3: {
            if (!(claims.length == 0)) {
                Sequence $this$any$iv = SequencesKt.filter((Sequence)SequencesKt.map((Sequence)ArraysKt.asSequence((Object[])claims), (Function1)containsAnyClaim.1.INSTANCE), (Function1)containsAnyClaim.2.INSTANCE);
                boolean $i$f$any = false;
                for (Object element$iv : $this$any$iv) {
                    List list = (List)element$iv;
                    boolean bl2 = false;
                    String key = (String)list.get(0);
                    String value = (String)list.get(1);
                    if (!jwtToken.containsClaim(((Object)StringsKt.trim((CharSequence)key)).toString(), ((Object)StringsKt.trim((CharSequence)value)).toString())) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            } else {
                boolean bl3;
                boolean it = bl3 = true;
                boolean bl4 = false;
                LOG.debug("no claims listed, so claim checking is ok.");
                bl = bl3;
            }
        }
        return bl;
    }

    static {
        Object[] objectArray = new KClass[]{Reflection.getOrCreateKotlinClass(RequiredIssuers.class), Reflection.getOrCreateKotlinClass(ProtectedWithClaims.class), Reflection.getOrCreateKotlinClass(Protected.class), Reflection.getOrCreateKotlinClass(Unprotected.class)};
        SUPPORTED_ANNOTATIONS = CollectionsKt.listOf((Object[])objectArray);
        Logger logger = LoggerFactory.getLogger(JwtTokenAnnotationHandler.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(...)");
        LOG = logger;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0010\u001b\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J9\u0010\u000b\u001a\u0004\u0018\u00010\n2\u0014\u0010\f\u001a\u0010\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\n0\t0\b2\u0012\u0010\r\u001a\n\u0012\u0006\b\u0001\u0012\u00020\n0\u000e\"\u00020\nH\u0002\u00a2\u0006\u0002\u0010\u000fR\u0014\u0010\u0003\u001a\u00020\u0004X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u001e\u0010\u0007\u001a\u0010\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\n0\t0\b8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lno/nav/security/token/support/core/validation/JwtTokenAnnotationHandler$Companion;", "", "()V", "LOG", "Lorg/slf4j/Logger;", "getLOG", "()Lorg/slf4j/Logger;", "SUPPORTED_ANNOTATIONS", "", "Lkotlin/reflect/KClass;", "", "findAnnotation", "types", "annotations", "", "(Ljava/util/List;[Ljava/lang/annotation/Annotation;)Ljava/lang/annotation/Annotation;", "token-validation-core"})
    @SourceDebugExtension(value={"SMAP\nJwtTokenAnnotationHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JwtTokenAnnotationHandler.kt\nno/nav/security/token/support/core/validation/JwtTokenAnnotationHandler$Companion\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,115:1\n1282#2,2:116\n*S KotlinDebug\n*F\n+ 1 JwtTokenAnnotationHandler.kt\nno/nav/security/token/support/core/validation/JwtTokenAnnotationHandler$Companion\n*L\n113#1:116,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        protected final Logger getLOG() {
            return LOG;
        }

        private final Annotation findAnnotation(List<? extends KClass<? extends Annotation>> types, Annotation ... annotations) {
            Annotation annotation;
            block1: {
                Annotation[] $this$firstOrNull$iv = annotations;
                boolean $i$f$firstOrNull = false;
                int n = $this$firstOrNull$iv.length;
                for (int i = 0; i < n; ++i) {
                    Annotation element$iv;
                    Annotation a = element$iv = $this$firstOrNull$iv[i];
                    boolean bl = false;
                    if (!types.contains(JvmClassMappingKt.getAnnotationClass((Annotation)a))) continue;
                    annotation = element$iv;
                    break block1;
                }
                annotation = null;
            }
            return annotation;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

