/*
 * Decompiled with CFR 0.152.
 */
package no.nav.security.token.support.core.configuration;

import com.nimbusds.jose.util.ResourceRetriever;
import com.nimbusds.oauth2.sdk.as.AuthorizationServerMetadata;
import java.net.URL;
import java.util.List;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import no.nav.security.token.support.core.configuration.IssuerProperties;
import no.nav.security.token.support.core.configuration.ProxyAwareResourceRetriever;
import no.nav.security.token.support.core.exceptions.MetaDataNotAvailableException;
import no.nav.security.token.support.core.validation.JwtTokenValidator;
import no.nav.security.token.support.core.validation.JwtTokenValidatorFactory;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0016\u0018\u0000 \u001c2\u00020\u0001:\u0001\u001cB\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\b\u0010\u001b\u001a\u00020\u0003H\u0016R\u0017\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00030\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\r\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0010\u001a\u00020\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u000fR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0011\u0010\u0017\u001a\u00020\u0018\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001a\u00a8\u0006\u001d"}, d2={"Lno/nav/security/token/support/core/configuration/IssuerConfiguration;", "", "name", "", "properties", "Lno/nav/security/token/support/core/configuration/IssuerProperties;", "resourceRetriever", "Lcom/nimbusds/jose/util/ResourceRetriever;", "(Ljava/lang/String;Lno/nav/security/token/support/core/configuration/IssuerProperties;Lcom/nimbusds/jose/util/ResourceRetriever;)V", "acceptedAudience", "", "getAcceptedAudience", "()Ljava/util/List;", "headerName", "getHeaderName", "()Ljava/lang/String;", "metadata", "Lcom/nimbusds/oauth2/sdk/as/AuthorizationServerMetadata;", "getMetadata", "()Lcom/nimbusds/oauth2/sdk/as/AuthorizationServerMetadata;", "getName", "getResourceRetriever", "()Lcom/nimbusds/jose/util/ResourceRetriever;", "tokenValidator", "Lno/nav/security/token/support/core/validation/JwtTokenValidator;", "getTokenValidator", "()Lno/nav/security/token/support/core/validation/JwtTokenValidator;", "toString", "Companion", "token-validation-core"})
public class IssuerConfiguration {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String name;
    @NotNull
    private final ResourceRetriever resourceRetriever;
    @NotNull
    private final AuthorizationServerMetadata metadata;
    @NotNull
    private final List<String> acceptedAudience;
    @NotNull
    private final String headerName;
    @NotNull
    private final JwtTokenValidator tokenValidator;

    public IssuerConfiguration(@NotNull String name, @NotNull IssuerProperties properties, @NotNull ResourceRetriever resourceRetriever) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)properties, (String)"properties");
        Intrinsics.checkNotNullParameter((Object)resourceRetriever, (String)"resourceRetriever");
        this.name = name;
        this.resourceRetriever = resourceRetriever;
        this.acceptedAudience = properties.getAcceptedAudience();
        this.headerName = properties.getHeaderName();
        AuthorizationServerMetadata authorizationServerMetadata = IssuerConfiguration.Companion.providerMetadata(this.resourceRetriever, properties.getDiscoveryUrl());
        Intrinsics.checkNotNullExpressionValue((Object)authorizationServerMetadata, (String)"access$providerMetadata(...)");
        this.metadata = authorizationServerMetadata;
        this.tokenValidator = JwtTokenValidatorFactory.tokenValidator(properties, this.metadata, this.resourceRetriever);
    }

    public /* synthetic */ IssuerConfiguration(String string, IssuerProperties issuerProperties, ResourceRetriever resourceRetriever, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            resourceRetriever = (ResourceRetriever)new ProxyAwareResourceRetriever(null, false, 3, null);
        }
        this(string, issuerProperties, resourceRetriever);
    }

    @NotNull
    public final String getName() {
        return this.name;
    }

    @NotNull
    public final ResourceRetriever getResourceRetriever() {
        return this.resourceRetriever;
    }

    @NotNull
    public final AuthorizationServerMetadata getMetadata() {
        return this.metadata;
    }

    @NotNull
    public final List<String> getAcceptedAudience() {
        return this.acceptedAudience;
    }

    @NotNull
    public final String getHeaderName() {
        return this.headerName;
    }

    @NotNull
    public final JwtTokenValidator getTokenValidator() {
        return this.tokenValidator;
    }

    @NotNull
    public String toString() {
        return this.getClass().getSimpleName() + " [name=" + this.name + ", metaData=" + this.metadata + ", acceptedAudience=" + this.acceptedAudience + ", headerName=" + this.headerName + ", tokenValidator=" + this.tokenValidator + ", resourceRetriever=" + this.resourceRetriever + "]";
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J \u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u00042\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0002\u00a8\u0006\n"}, d2={"Lno/nav/security/token/support/core/configuration/IssuerConfiguration$Companion;", "", "()V", "providerMetadata", "Lcom/nimbusds/oauth2/sdk/as/AuthorizationServerMetadata;", "kotlin.jvm.PlatformType", "retriever", "Lcom/nimbusds/jose/util/ResourceRetriever;", "url", "Ljava/net/URL;", "token-validation-core"})
    public static final class Companion {
        private Companion() {
        }

        private final AuthorizationServerMetadata providerMetadata(ResourceRetriever retriever, URL url) {
            Object $this$providerMetadata_u24lambda_u240;
            Object object = this;
            try {
                $this$providerMetadata_u24lambda_u240 = object;
                boolean bl = false;
                $this$providerMetadata_u24lambda_u240 = Result.constructor-impl((Object)AuthorizationServerMetadata.parse((String)retriever.retrieveResource(url).getContent()));
            }
            catch (Throwable bl) {
                $this$providerMetadata_u24lambda_u240 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl));
            }
            object = $this$providerMetadata_u24lambda_u240;
            Throwable throwable = Result.exceptionOrNull-impl((Object)object);
            if (throwable != null) {
                Throwable it = throwable;
                boolean bl = false;
                throw new MetaDataNotAvailableException("Make sure you are not using proxying in GCP", url, it);
            }
            return (AuthorizationServerMetadata)object;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

