/*
 * Decompiled with CFR 0.152.
 */
package no.nav.security.token.support.core.validation;

import com.nimbusds.jose.JWSAlgorithm;
import com.nimbusds.jose.jwk.source.JWKSource;
import com.nimbusds.jose.proc.JWSKeySelector;
import com.nimbusds.jose.proc.JWSVerificationKeySelector;
import com.nimbusds.jose.proc.SecurityContext;
import com.nimbusds.jwt.JWTClaimsSet;
import com.nimbusds.jwt.proc.DefaultJWTProcessor;
import com.nimbusds.jwt.proc.JWTClaimsSetVerifier;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import no.nav.security.token.support.core.exceptions.JwtTokenValidatorException;
import no.nav.security.token.support.core.validation.DefaultJwtClaimsVerifier;
import no.nav.security.token.support.core.validation.JwtTokenValidator;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\u0018\u0000 \u00122\u00020\u0001:\u0001\u0012B7\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b\u00a2\u0006\u0002\u0010\nJ\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0003H\u0016R\u0017\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00020\t0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lno/nav/security/token/support/core/validation/DefaultConfigurableJwtValidator;", "Lno/nav/security/token/support/core/validation/JwtTokenValidator;", "issuer", "", "acceptedAudiences", "", "optionalClaims", "jwkSource", "Lcom/nimbusds/jose/jwk/source/JWKSource;", "Lcom/nimbusds/jose/proc/SecurityContext;", "(Ljava/lang/String;Ljava/util/List;Ljava/util/List;Lcom/nimbusds/jose/jwk/source/JWKSource;)V", "getJwkSource", "()Lcom/nimbusds/jose/jwk/source/JWKSource;", "jwtProcessor", "Lcom/nimbusds/jwt/proc/DefaultJWTProcessor;", "assertValidToken", "", "tokenString", "Companion", "token-validation-core"})
public final class DefaultConfigurableJwtValidator
implements JwtTokenValidator {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final JWKSource<SecurityContext> jwkSource;
    @NotNull
    private final DefaultJWTProcessor<SecurityContext> jwtProcessor;
    @NotNull
    private static final List<String> DEFAULT_REQUIRED_CLAIMS;
    @NotNull
    private static final Set<String> PROHIBITED_CLAIMS;

    /*
     * WARNING - void declaration
     */
    public DefaultConfigurableJwtValidator(@NotNull String issuer, @NotNull List<String> acceptedAudiences, @NotNull List<String> optionalClaims, @NotNull JWKSource<SecurityContext> jwkSource) {
        void $this$jwtProcessor_u24lambda_u240;
        DefaultJWTProcessor defaultJWTProcessor;
        Intrinsics.checkNotNullParameter((Object)issuer, (String)"issuer");
        Intrinsics.checkNotNullParameter(acceptedAudiences, (String)"acceptedAudiences");
        Intrinsics.checkNotNullParameter(optionalClaims, (String)"optionalClaims");
        Intrinsics.checkNotNullParameter(jwkSource, (String)"jwkSource");
        this.jwkSource = jwkSource;
        DefaultJWTProcessor defaultJWTProcessor2 = defaultJWTProcessor = new DefaultJWTProcessor();
        DefaultConfigurableJwtValidator defaultConfigurableJwtValidator = this;
        boolean bl = false;
        $this$jwtProcessor_u24lambda_u240.setJWSKeySelector((JWSKeySelector)new JWSVerificationKeySelector(JWSAlgorithm.RS256, this.jwkSource));
        Set set = DefaultConfigurableJwtValidator.Companion.acceptedAudiences(acceptedAudiences, optionalClaims);
        JWTClaimsSet jWTClaimsSet = new JWTClaimsSet.Builder().issuer(issuer).build();
        Intrinsics.checkNotNullExpressionValue((Object)jWTClaimsSet, (String)"build(...)");
        $this$jwtProcessor_u24lambda_u240.setJWTClaimsSetVerifier((JWTClaimsSetVerifier)new DefaultJwtClaimsVerifier(set, jWTClaimsSet, DefaultConfigurableJwtValidator.Companion.difference(DefaultConfigurableJwtValidator.DEFAULT_REQUIRED_CLAIMS, optionalClaims), PROHIBITED_CLAIMS));
        defaultConfigurableJwtValidator.jwtProcessor = defaultJWTProcessor;
    }

    @NotNull
    public final JWKSource<SecurityContext> getJwkSource() {
        return this.jwkSource;
    }

    @Override
    public void assertValidToken(@NotNull String tokenString) {
        Object $this$assertValidToken_u24lambda_u241;
        Intrinsics.checkNotNullParameter((Object)tokenString, (String)"tokenString");
        Object object = this;
        try {
            $this$assertValidToken_u24lambda_u241 = object;
            boolean bl = false;
            $this$assertValidToken_u24lambda_u241 = Result.constructor-impl((Object)((DefaultConfigurableJwtValidator)$this$assertValidToken_u24lambda_u241).jwtProcessor.process(tokenString, null));
        }
        catch (Throwable bl) {
            $this$assertValidToken_u24lambda_u241 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl));
        }
        object = $this$assertValidToken_u24lambda_u241;
        Throwable throwable = Result.exceptionOrNull-impl((Object)object);
        if (throwable != null) {
            Throwable it = throwable;
            boolean bl = false;
            throw new JwtTokenValidatorException("Token validation failed: " + it.getMessage(), it);
        }
    }

    static {
        Object[] objectArray = new String[]{"aud", "exp", "iat", "iss", "sub"};
        DEFAULT_REQUIRED_CLAIMS = CollectionsKt.listOf((Object[])objectArray);
        PROHIBITED_CLAIMS = SetsKt.emptySet();
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\"\n\u0002\b\u0007\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J.\u0010\b\u001a\f\u0012\u0006\u0012\u0004\u0018\u00010\u0005\u0018\u00010\u00072\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004H\u0002J0\u0010\n\u001a\b\u0012\u0004\u0012\u0002H\u000b0\u0007\"\u0004\b\u0000\u0010\u000b2\f\u0010\f\u001a\b\u0012\u0004\u0012\u0002H\u000b0\u00042\f\u0010\r\u001a\b\u0012\u0004\u0012\u0002H\u000b0\u0004H\u0002R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lno/nav/security/token/support/core/validation/DefaultConfigurableJwtValidator$Companion;", "", "()V", "DEFAULT_REQUIRED_CLAIMS", "", "", "PROHIBITED_CLAIMS", "", "acceptedAudiences", "optionalClaims", "difference", "T", "first", "second", "token-validation-core"})
    public static final class Companion {
        private Companion() {
        }

        private final Set<String> acceptedAudiences(List<String> acceptedAudiences, List<String> optionalClaims) {
            return !optionalClaims.contains("aud") ? CollectionsKt.toSet((Iterable)acceptedAudiences) : (acceptedAudiences.isEmpty() ? null : CollectionsKt.toSet((Iterable)CollectionsKt.plus((Collection)acceptedAudiences, null)));
        }

        private final <T> Set<T> difference(List<? extends T> first, List<? extends T> second) {
            return SequencesKt.toSet((Sequence)SequencesKt.filterNot((Sequence)CollectionsKt.asSequence((Iterable)first), (Function1)new Function1<T, Boolean>(second){
                final /* synthetic */ List<T> $second;
                {
                    this.$second = $second;
                    super(1);
                }

                @NotNull
                public final Boolean invoke(T it) {
                    return this.$second.contains(it);
                }
            }));
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

