/*
 * Decompiled with CFR 0.152.
 */
package no.nav.security.token.support.jaxrs;

import java.util.Collections;
import javax.inject.Inject;
import javax.ws.rs.client.ClientRequestContext;
import javax.ws.rs.client.ClientRequestFilter;
import no.nav.security.token.support.core.context.TokenValidationContext;
import no.nav.security.token.support.jaxrs.JaxrsTokenValidationContextHolder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JwtTokenClientRequestFilter
implements ClientRequestFilter {
    private static final Logger logger = LoggerFactory.getLogger(JwtTokenClientRequestFilter.class);

    @Inject
    public JwtTokenClientRequestFilter() {
    }

    public void filter(ClientRequestContext requestContext) {
        TokenValidationContext context = JaxrsTokenValidationContextHolder.getHolder().getTokenValidationContext();
        if (context != null && context.hasValidToken()) {
            logger.debug("adding tokens to Authorization header");
            StringBuilder headerValue = new StringBuilder();
            for (String issuer : context.getIssuers()) {
                logger.debug("adding token for issuer {}", (Object)issuer);
                headerValue.append("Bearer ").append(context.getJwtToken(issuer).getTokenAsString());
            }
            requestContext.getHeaders().put((Object)"Authorization", Collections.singletonList(headerValue.toString()));
        } else {
            logger.debug("no tokens found, nothing added to request");
        }
    }
}

