/*
 * Decompiled with CFR 0.152.
 */
package no.nav.security.token.support.jaxrs;

import jakarta.inject.Inject;
import jakarta.ws.rs.WebApplicationException;
import jakarta.ws.rs.container.ContainerRequestContext;
import jakarta.ws.rs.container.ContainerRequestFilter;
import jakarta.ws.rs.container.ResourceInfo;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.ext.Provider;
import java.lang.reflect.Method;
import no.nav.security.token.support.core.exceptions.JwtTokenInvalidClaimException;
import no.nav.security.token.support.core.validation.JwtTokenAnnotationHandler;
import no.nav.security.token.support.jaxrs.JaxrsTokenValidationContextHolder;

@Provider
public class JwtTokenContainerRequestFilter
implements ContainerRequestFilter {
    private final JwtTokenAnnotationHandler jwtTokenAnnotationHandler = new JwtTokenAnnotationHandler(JaxrsTokenValidationContextHolder.getHolder());
    @Context
    private ResourceInfo resourceInfo;

    @Inject
    public JwtTokenContainerRequestFilter() {
    }

    public void filter(ContainerRequestContext containerRequestContext) {
        Method method = this.resourceInfo.getResourceMethod();
        try {
            this.jwtTokenAnnotationHandler.assertValidAnnotation(method);
        }
        catch (JwtTokenInvalidClaimException e) {
            throw new WebApplicationException((Throwable)e, Response.Status.FORBIDDEN);
        }
        catch (Exception e) {
            throw new WebApplicationException((Throwable)e, Response.Status.UNAUTHORIZED);
        }
    }
}

