/*
 * Decompiled with CFR 0.152.
 */
package no.nav.security.token.support.jaxrs;

import jakarta.inject.Inject;
import jakarta.ws.rs.client.ClientRequestContext;
import jakarta.ws.rs.client.ClientRequestFilter;
import jakarta.ws.rs.core.MultivaluedMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import no.nav.security.token.support.core.context.TokenValidationContext;
import no.nav.security.token.support.core.jwt.JwtToken;
import no.nav.security.token.support.jaxrs.JaxrsTokenValidationContextHolder;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00072\u00020\u0001:\u0001\u0007B\u0007\b\u0007\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\b"}, d2={"Lno/nav/security/token/support/jaxrs/JwtTokenClientRequestFilter;", "Ljakarta/ws/rs/client/ClientRequestFilter;", "()V", "filter", "", "requestContext", "Ljakarta/ws/rs/client/ClientRequestContext;", "Companion", "token-validation-jaxrs"})
public final class JwtTokenClientRequestFilter
implements ClientRequestFilter {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final Logger LOG;

    @Inject
    public JwtTokenClientRequestFilter() {
    }

    public void filter(@NotNull ClientRequestContext requestContext) {
        Intrinsics.checkNotNullParameter((Object)requestContext, (String)"requestContext");
        TokenValidationContext context = JaxrsTokenValidationContextHolder.INSTANCE.getHolder().getTokenValidationContext();
        if (context.hasValidToken()) {
            LOG.debug("Adding tokens to Authorization header");
            String headerValue2 = CollectionsKt.joinToString$default((Iterable)context.getIssuers(), (CharSequence)"", null, null, (int)0, null, (Function1)((Function1)new Function1<String, CharSequence>(context){
                final /* synthetic */ TokenValidationContext $context;
                {
                    this.$context = $context;
                    super(1);
                }

                @NotNull
                public final CharSequence invoke(@NotNull String it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    JwtTokenClientRequestFilter.access$getLOG$cp().debug("Adding token for issuer " + it);
                    JwtToken jwtToken = this.$context.getJwtToken(it);
                    return "Bearer " + (jwtToken != null ? jwtToken.getEncodedToken() : null);
                }
            }), (int)30, null);
            MultivaluedMap multivaluedMap = requestContext.getHeaders();
            Intrinsics.checkNotNullExpressionValue((Object)multivaluedMap, (String)"getHeaders(...)");
            Map map = (Map)multivaluedMap;
            String string = "Authorization";
            List list = CollectionsKt.listOf((Object)headerValue2);
            map.put(string, list);
        } else {
            LOG.debug("No tokens found, nothing added to request");
        }
    }

    public static final /* synthetic */ Logger access$getLOG$cp() {
        return LOG;
    }

    static {
        Logger logger = LoggerFactory.getLogger(JwtTokenClientRequestFilter.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(...)");
        LOG = logger;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lno/nav/security/token/support/jaxrs/JwtTokenClientRequestFilter$Companion;", "", "()V", "LOG", "Lorg/slf4j/Logger;", "token-validation-jaxrs"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

