/*
 * Decompiled with CFR 0.152.
 */
package no.nav.security.token.support.ktor;

import io.ktor.application.ApplicationCall;
import io.ktor.response.ApplicationResponse;
import io.ktor.response.ApplicationResponsePropertiesKt;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.temporal.ChronoUnit;
import java.util.Date;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import no.nav.security.token.support.core.context.TokenValidationContext;
import no.nav.security.token.support.core.jwt.JwtTokenClaims;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0016\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rJ\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0005\u001a\n \u0007*\u0004\u0018\u00010\u00060\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lno/nav/security/token/support/ktor/JwtTokenExpiryThresholdHandler;", "", "expiryThreshold", "", "(I)V", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "addHeaderOnTokenExpiryThreshold", "", "call", "Lio/ktor/application/ApplicationCall;", "tokenValidationContext", "Lno/nav/security/token/support/core/context/TokenValidationContext;", "tokenExpiresBeforeThreshold", "", "jwtTokenClaims", "Lno/nav/security/token/support/core/jwt/JwtTokenClaims;", "token-validation-ktor"})
public final class JwtTokenExpiryThresholdHandler {
    private final Logger log;
    private final int expiryThreshold;

    public final void addHeaderOnTokenExpiryThreshold(@NotNull ApplicationCall call, @NotNull TokenValidationContext tokenValidationContext) {
        Intrinsics.checkNotNullParameter((Object)call, (String)"call");
        Intrinsics.checkNotNullParameter((Object)tokenValidationContext, (String)"tokenValidationContext");
        if (this.expiryThreshold > 0) {
            for (String issuer : tokenValidationContext.getIssuers()) {
                JwtTokenClaims jwtTokenClaims;
                JwtTokenClaims jwtTokenClaims2 = jwtTokenClaims = tokenValidationContext.getClaims(issuer);
                Intrinsics.checkNotNullExpressionValue((Object)jwtTokenClaims2, (String)"jwtTokenClaims");
                if (this.tokenExpiresBeforeThreshold(jwtTokenClaims2)) {
                    ApplicationResponsePropertiesKt.header((ApplicationResponse)call.getResponse(), (String)"x-token-expires-soon", (String)"true");
                    continue;
                }
                this.log.debug("Token is still within expiry threshold.");
            }
        } else {
            this.log.debug("Expiry threshold is not set");
        }
    }

    private final boolean tokenExpiresBeforeThreshold(JwtTokenClaims jwtTokenClaims) {
        Object object = jwtTokenClaims.get("exp");
        if (object == null) {
            throw new NullPointerException("null cannot be cast to non-null type java.util.Date");
        }
        Date expiryDate = (Date)object;
        LocalDateTime expiry = LocalDateTime.ofInstant(expiryDate.toInstant(), ZoneId.systemDefault());
        long minutesUntilExpiry = LocalDateTime.now().until(expiry, ChronoUnit.MINUTES);
        this.log.debug("Checking token at time {} with expirationTime {} for how many minutes until expiry: {}", new Object[]{LocalDateTime.now(), expiry, minutesUntilExpiry});
        if (minutesUntilExpiry <= (long)this.expiryThreshold) {
            this.log.debug("There are {} minutes until expiry which is equal to or less than the configured threshold {}", (Object)minutesUntilExpiry, (Object)this.expiryThreshold);
            return true;
        }
        return false;
    }

    public JwtTokenExpiryThresholdHandler(int expiryThreshold) {
        this.expiryThreshold = expiryThreshold;
        this.log = LoggerFactory.getLogger((String)JwtTokenExpiryThresholdHandler.class.getName());
    }
}

