/*
 * Decompiled with CFR 0.152.
 */
package no.nav.security.token.support.ktor;

import java.util.Optional;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import no.nav.security.token.support.core.context.TokenValidationContextHolder;
import no.nav.security.token.support.core.exceptions.JwtTokenInvalidClaimException;
import no.nav.security.token.support.core.exceptions.JwtTokenMissingException;
import no.nav.security.token.support.core.jwt.JwtToken;
import no.nav.security.token.support.core.utils.JwtTokenUtil;
import no.nav.security.token.support.core.validation.JwtTokenAnnotationHandler;
import no.nav.security.token.support.ktor.RequiredClaims;
import no.nav.security.token.support.ktor.RequiredClaimsException;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0015\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0000\u00a2\u0006\u0002\b\tR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lno/nav/security/token/support/ktor/RequiredClaimsHandler;", "Lno/nav/security/token/support/core/validation/JwtTokenAnnotationHandler;", "tokenValidationContextHolder", "Lno/nav/security/token/support/core/context/TokenValidationContextHolder;", "(Lno/nav/security/token/support/core/context/TokenValidationContextHolder;)V", "handleRequiredClaims", "", "requiredClaims", "Lno/nav/security/token/support/ktor/RequiredClaims;", "handleRequiredClaims$token_validation_ktor", "token-validation-ktor"})
public final class RequiredClaimsHandler
extends JwtTokenAnnotationHandler {
    @NotNull
    private final TokenValidationContextHolder tokenValidationContextHolder;

    public RequiredClaimsHandler(@NotNull TokenValidationContextHolder tokenValidationContextHolder) {
        Intrinsics.checkNotNullParameter((Object)tokenValidationContextHolder, (String)"tokenValidationContextHolder");
        super(tokenValidationContextHolder);
        this.tokenValidationContextHolder = tokenValidationContextHolder;
    }

    public final void handleRequiredClaims$token_validation_ktor(@NotNull RequiredClaims requiredClaims) {
        Intrinsics.checkNotNullParameter((Object)requiredClaims, (String)"requiredClaims");
        try {
            Optional jwtToken = JwtTokenUtil.getJwtToken((String)requiredClaims.getIssuer(), (TokenValidationContextHolder)this.tokenValidationContextHolder);
            if (jwtToken.isEmpty()) {
                throw new JwtTokenMissingException("no valid token found in validation context");
            }
            if (!this.handleProtectedWithClaims(requiredClaims.getIssuer(), requiredClaims.getClaimMap(), requiredClaims.getCombineWithOr(), (JwtToken)jwtToken.get())) {
                throw new JwtTokenInvalidClaimException("required claims not present in token." + requiredClaims.getClaimMap());
            }
        }
        catch (RuntimeException e) {
            String string = e.getMessage();
            if (string == null) {
                string = "";
            }
            throw new RequiredClaimsException(string, e);
        }
    }
}

