/*
 * Decompiled with CFR 0.152.
 */
package no.nav.security.token.support.spring.validation.interceptor;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import no.nav.security.token.support.core.validation.JwtTokenAnnotationHandler;
import no.nav.security.token.support.spring.validation.interceptor.JwtTokenUnauthorizedException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.annotation.AnnotationAttributes;
import org.springframework.web.method.HandlerMethod;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.ModelAndView;

public class JwtTokenHandlerInterceptor
implements HandlerInterceptor {
    private final Logger logger = LoggerFactory.getLogger(JwtTokenHandlerInterceptor.class);
    private final JwtTokenAnnotationHandler jwtTokenAnnotationHandler;
    private String[] ignoreConfig;
    private final Map<Object, Boolean> handlerFlags = new ConcurrentHashMap<Object, Boolean>();

    public JwtTokenHandlerInterceptor(AnnotationAttributes enableJwtTokenValidation, JwtTokenAnnotationHandler jwtTokenAnnotationHandler) {
        this.jwtTokenAnnotationHandler = jwtTokenAnnotationHandler;
        if (enableJwtTokenValidation != null) {
            this.ignoreConfig = enableJwtTokenValidation.getStringArray("ignore");
            if (this.ignoreConfig == null) {
                this.ignoreConfig = new String[0];
            }
        } else {
            this.ignoreConfig = new String[0];
        }
    }

    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) {
        if (handler instanceof HandlerMethod) {
            HandlerMethod handlerMethod = (HandlerMethod)handler;
            if (this.shouldIgnore(handlerMethod.getBean())) {
                return true;
            }
            try {
                return this.jwtTokenAnnotationHandler.assertValidAnnotation(handlerMethod.getMethod());
            }
            catch (Exception e) {
                throw new JwtTokenUnauthorizedException(e);
            }
        }
        this.logger.debug("Handler is of type {}, allowing unprotected access to the resources it accesses", (Object)handler.getClass().getSimpleName());
        return true;
    }

    public void afterCompletion(HttpServletRequest arg0, HttpServletResponse arg1, Object handler, Exception arg3) {
    }

    public void postHandle(HttpServletRequest arg0, HttpServletResponse arg1, Object handler, ModelAndView arg3) {
    }

    private boolean shouldIgnore(Object object) {
        Boolean flag = this.handlerFlags.get(object);
        if (flag != null) {
            return flag;
        }
        String fullName = object.getClass().getName();
        for (String ignore : this.ignoreConfig) {
            if (!fullName.startsWith(ignore)) continue;
            this.logger.info("Adding " + fullName + " to OIDC validation ignore list");
            this.handlerFlags.put(object, true);
            return true;
        }
        this.logger.info("Adding " + fullName + " to OIDC validation interceptor list");
        this.handlerFlags.put(object, false);
        return false;
    }
}

