/*
 * Decompiled with CFR 0.152.
 */
package no.nav.security.token.support.spring.validation.interceptor;

import java.io.IOException;
import no.nav.security.token.support.core.context.TokenValidationContext;
import no.nav.security.token.support.core.context.TokenValidationContextHolder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpRequest;
import org.springframework.http.client.ClientHttpRequestExecution;
import org.springframework.http.client.ClientHttpRequestInterceptor;
import org.springframework.http.client.ClientHttpResponse;

public class BearerTokenClientHttpRequestInterceptor
implements ClientHttpRequestInterceptor {
    private final TokenValidationContextHolder contextHolder;
    private final Logger logger = LoggerFactory.getLogger(BearerTokenClientHttpRequestInterceptor.class);

    public BearerTokenClientHttpRequestInterceptor(TokenValidationContextHolder contextHolder) {
        this.contextHolder = contextHolder;
    }

    public ClientHttpResponse intercept(HttpRequest request, byte[] body, ClientHttpRequestExecution execution) throws IOException {
        TokenValidationContext context = this.contextHolder.getTokenValidationContext();
        if (context != null && context.hasValidToken()) {
            this.logger.debug("adding tokens to Authorization header");
            StringBuilder headerValue = new StringBuilder();
            boolean first = true;
            for (String issuer : context.getIssuers()) {
                this.logger.debug("adding token for issuer {}", (Object)issuer);
                if (!first) {
                    headerValue.append(",");
                }
                headerValue.append("Bearer " + context.getJwtToken(issuer).getTokenAsString());
                first = false;
            }
            request.getHeaders().add("Authorization", headerValue.toString());
        } else {
            this.logger.debug("no tokens found, nothing added to request");
        }
        return execution.execute(request, body);
    }
}

