/*
 * Decompiled with CFR 0.152.
 */
package no.nav.security.token.support.spring.validation.interceptor;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import no.nav.security.token.support.core.context.TokenValidationContextHolder;
import no.nav.security.token.support.core.validation.JwtTokenAnnotationHandler;
import org.springframework.core.annotation.AnnotationUtils;

public class SpringJwtTokenAnnotationHandler
extends JwtTokenAnnotationHandler {
    public SpringJwtTokenAnnotationHandler(TokenValidationContextHolder tokenValidationContextHolder) {
        super(tokenValidationContextHolder);
    }

    protected Annotation getAnnotation(Method method, List<Class<? extends Annotation>> types) {
        return Optional.ofNullable(SpringJwtTokenAnnotationHandler.scanAnnotation(method, types)).orElseGet(() -> SpringJwtTokenAnnotationHandler.scanAnnotation(method.getDeclaringClass(), types));
    }

    private static Annotation scanAnnotation(Method m, List<Class<? extends Annotation>> types) {
        return types.stream().map(t -> AnnotationUtils.findAnnotation((Method)m, (Class)t)).filter(Objects::nonNull).findFirst().orElse(null);
    }

    private static Annotation scanAnnotation(Class<?> clazz, List<Class<? extends Annotation>> types) {
        return types.stream().map(t -> AnnotationUtils.findAnnotation((Class)clazz, (Class)t)).filter(Objects::nonNull).findFirst().orElse(null);
    }
}

