/*
 * Decompiled with CFR 0.152.
 */
package no.nav.security.token.support.spring.validation.interceptor;

import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import no.nav.security.token.support.core.context.TokenValidationContextHolder;
import no.nav.security.token.support.core.validation.JwtTokenAnnotationHandler;
import org.springframework.core.annotation.AnnotatedElementUtils;

public final class SpringJwtTokenAnnotationHandler
extends JwtTokenAnnotationHandler {
    public SpringJwtTokenAnnotationHandler(TokenValidationContextHolder holder) {
        super(holder);
    }

    protected Annotation getAnnotation(Method m, List<Class<? extends Annotation>> types) {
        return Optional.ofNullable(SpringJwtTokenAnnotationHandler.findAnnotation(m, types)).orElseGet(() -> SpringJwtTokenAnnotationHandler.findAnnotation(m.getDeclaringClass(), types));
    }

    private static Annotation findAnnotation(AnnotatedElement e, List<Class<? extends Annotation>> types) {
        return types.stream().map(t -> AnnotatedElementUtils.findMergedAnnotation((AnnotatedElement)e, (Class)t)).filter(Objects::nonNull).findFirst().orElse(null);
    }
}

