/*
 * Decompiled with CFR 0.152.
 */
package no.nav.security.token.support.spring.validation.interceptor;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import no.nav.security.token.support.core.exceptions.AnnotationRequiredException;
import no.nav.security.token.support.core.validation.JwtTokenAnnotationHandler;
import no.nav.security.token.support.spring.validation.interceptor.JwtTokenUnauthorizedException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.annotation.AnnotationAttributes;
import org.springframework.http.HttpStatus;
import org.springframework.web.method.HandlerMethod;
import org.springframework.web.server.ResponseStatusException;
import org.springframework.web.servlet.HandlerInterceptor;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0010\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u0017\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J \u0010\u0012\u001a\u00020\n2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\tH\u0016J\u0010\u0010\u0018\u001a\u00020\n2\u0006\u0010\u0019\u001a\u00020\tH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R4\u0010\u000b\u001a&\u0012\f\u0012\n \u000e*\u0004\u0018\u00010\r0\r \u000e*\u0012\u0012\u000e\b\u0001\u0012\n \u000e*\u0004\u0018\u00010\r0\r0\f0\fX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u000fR\u0016\u0010\u0010\u001a\n \u000e*\u0004\u0018\u00010\u00110\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lno/nav/security/token/support/spring/validation/interceptor/JwtTokenHandlerInterceptor;", "Lorg/springframework/web/servlet/HandlerInterceptor;", "attrs", "Lorg/springframework/core/annotation/AnnotationAttributes;", "h", "Lno/nav/security/token/support/core/validation/JwtTokenAnnotationHandler;", "(Lorg/springframework/core/annotation/AnnotationAttributes;Lno/nav/security/token/support/core/validation/JwtTokenAnnotationHandler;)V", "handlerFlags", "", "", "", "ignoreConfig", "", "", "kotlin.jvm.PlatformType", "[Ljava/lang/String;", "log", "Lorg/slf4j/Logger;", "preHandle", "request", "Ljavax/servlet/http/HttpServletRequest;", "response", "Ljavax/servlet/http/HttpServletResponse;", "handler", "shouldIgnore", "o", "token-validation-spring"})
public final class JwtTokenHandlerInterceptor
implements HandlerInterceptor {
    @NotNull
    private final JwtTokenAnnotationHandler h;
    private final Logger log;
    @NotNull
    private final Map<Object, Boolean> handlerFlags;
    @NotNull
    private final String[] ignoreConfig;

    public JwtTokenHandlerInterceptor(@Nullable AnnotationAttributes attrs, @NotNull JwtTokenAnnotationHandler h) {
        Intrinsics.checkNotNullParameter((Object)h, (String)"h");
        this.h = h;
        this.log = LoggerFactory.getLogger(JwtTokenHandlerInterceptor.class);
        this.handlerFlags = new ConcurrentHashMap();
        AnnotationAttributes annotationAttributes = attrs;
        String[] stringArray = annotationAttributes == null ? null : annotationAttributes.getStringArray("ignore");
        if (stringArray == null) {
            String[] stringArray2 = new String[]{};
            stringArray = stringArray2;
        }
        this.ignoreConfig = stringArray;
    }

    public boolean preHandle(@NotNull HttpServletRequest request, @NotNull HttpServletResponse response, @NotNull Object handler) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter((Object)response, (String)"response");
        Intrinsics.checkNotNullParameter((Object)handler, (String)"handler");
        if (handler instanceof HandlerMethod) {
            boolean bl;
            Object object = ((HandlerMethod)handler).getBean();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"handler.bean");
            if (this.shouldIgnore(object)) {
                bl = true;
            } else {
                boolean bl2;
                try {
                    bl2 = this.h.assertValidAnnotation(((HandlerMethod)handler).getMethod());
                }
                catch (AnnotationRequiredException e) {
                    this.log.warn("Received AnnotationRequiredException from JwtTokenAnnotationHandler. return status=" + HttpStatus.NOT_IMPLEMENTED, (Throwable)e);
                    throw new ResponseStatusException(HttpStatus.NOT_IMPLEMENTED, "Endpoint not accessible");
                }
                catch (Exception e) {
                    throw new JwtTokenUnauthorizedException(e);
                }
                bl = bl2;
            }
            return bl;
        }
        this.log.debug("Handler is of type " + handler.getClass().getSimpleName() + ", allowing unprotected access to the resources it accesses");
        return true;
    }

    private final boolean shouldIgnore(Object o) {
        Boolean flag = this.handlerFlags.get(o);
        if (flag != null) {
            return flag;
        }
        String fullName = o.getClass().getName();
        String[] $this$forEach$iv = this.ignoreConfig;
        boolean $i$f$forEach = false;
        for (String element$iv : $this$forEach$iv) {
            String ignore = element$iv;
            boolean bl = false;
            Intrinsics.checkNotNullExpressionValue((Object)fullName, (String)"fullName");
            Intrinsics.checkNotNullExpressionValue((Object)ignore, (String)"ignore");
            if (!StringsKt.startsWith$default((String)fullName, (String)ignore, (boolean)false, (int)2, null)) continue;
            this.log.info("Adding " + fullName + " to OIDC validation ignore list");
            Map<Object, Boolean> map = this.handlerFlags;
            Boolean bl2 = true;
            map.put(o, bl2);
            return true;
        }
        this.log.info("Adding " + fullName + " to OIDC validation interceptor list");
        Map<Object, Boolean> map = this.handlerFlags;
        Boolean bl = false;
        map.put(o, bl);
        return false;
    }
}

