/*
 * Decompiled with CFR 0.152.
 */
package no.nav.security.token.support.spring.validation.interceptor;

import java.io.IOException;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import no.nav.security.token.support.core.context.TokenValidationContext;
import no.nav.security.token.support.core.context.TokenValidationContextHolder;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpRequest;
import org.springframework.http.client.ClientHttpRequestExecution;
import org.springframework.http.client.ClientHttpRequestInterceptor;
import org.springframework.http.client.ClientHttpResponse;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J \u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0005\u001a\n \u0007*\u0004\u0018\u00010\u00060\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lno/nav/security/token/support/spring/validation/interceptor/BearerTokenClientHttpRequestInterceptor;", "Lorg/springframework/http/client/ClientHttpRequestInterceptor;", "holder", "Lno/nav/security/token/support/core/context/TokenValidationContextHolder;", "(Lno/nav/security/token/support/core/context/TokenValidationContextHolder;)V", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "intercept", "Lorg/springframework/http/client/ClientHttpResponse;", "req", "Lorg/springframework/http/HttpRequest;", "body", "", "execution", "Lorg/springframework/http/client/ClientHttpRequestExecution;", "token-validation-spring"})
public final class BearerTokenClientHttpRequestInterceptor
implements ClientHttpRequestInterceptor {
    @NotNull
    private final TokenValidationContextHolder holder;
    private final Logger log;

    public BearerTokenClientHttpRequestInterceptor(@NotNull TokenValidationContextHolder holder) {
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        this.holder = holder;
        this.log = LoggerFactory.getLogger(BearerTokenClientHttpRequestInterceptor.class);
    }

    @NotNull
    public ClientHttpResponse intercept(@NotNull HttpRequest req, @NotNull byte[] body, @NotNull ClientHttpRequestExecution execution) throws IOException {
        Intrinsics.checkNotNullParameter((Object)req, (String)"req");
        Intrinsics.checkNotNullParameter((Object)body, (String)"body");
        Intrinsics.checkNotNullParameter((Object)execution, (String)"execution");
        TokenValidationContext tokenValidationContext = this.holder.getTokenValidationContext();
        if (tokenValidationContext != null) {
            TokenValidationContext tokenValidationContext2;
            TokenValidationContext $this$intercept_u24lambda_u240 = tokenValidationContext2 = tokenValidationContext;
            boolean bl = false;
            if ($this$intercept_u24lambda_u240.hasValidToken()) {
                this.log.debug("Adding tokens to Authorization header");
                HttpHeaders httpHeaders = req.getHeaders();
                List list = $this$intercept_u24lambda_u240.getIssuers();
                Intrinsics.checkNotNullExpressionValue((Object)list, (String)"issuers");
                httpHeaders.add("Authorization", CollectionsKt.joinToString$default((Iterable)list, null, null, null, (int)0, null, (Function1)((Function1)new Function1<String, CharSequence>($this$intercept_u24lambda_u240){
                    final /* synthetic */ TokenValidationContext $this_apply;
                    {
                        this.$this_apply = $receiver;
                        super(1);
                    }

                    @NotNull
                    public final CharSequence invoke(String it) {
                        return "Bearer " + this.$this_apply.getJwtToken(it).getTokenAsString();
                    }
                }), (int)31, null));
            }
        } else {
            this.log.debug("no tokens found, nothing added to request");
        }
        ClientHttpResponse clientHttpResponse = execution.execute(req, body);
        Intrinsics.checkNotNullExpressionValue((Object)clientHttpResponse, (String)"execution.execute(req, body)");
        return clientHttpResponse;
    }
}

