/*
 * Decompiled with CFR 0.152.
 */
package no.nav.security.token.support.spring.validation.interceptor;

import java.io.IOException;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import no.nav.security.token.support.core.context.TokenValidationContext;
import no.nav.security.token.support.core.context.TokenValidationContextHolder;
import no.nav.security.token.support.core.jwt.JwtToken;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpRequest;
import org.springframework.http.client.ClientHttpRequestExecution;
import org.springframework.http.client.ClientHttpRequestInterceptor;
import org.springframework.http.client.ClientHttpResponse;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J \u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u0006\u001a\n \b*\u0004\u0018\u00010\u00070\u0007X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\t\u00a8\u0006\u0012"}, d2={"Lno/nav/security/token/support/spring/validation/interceptor/BearerTokenClientHttpRequestInterceptor;", "Lorg/springframework/http/client/ClientHttpRequestInterceptor;", "holder", "Lno/nav/security/token/support/core/context/TokenValidationContextHolder;", "<init>", "(Lno/nav/security/token/support/core/context/TokenValidationContextHolder;)V", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "Lorg/slf4j/Logger;", "intercept", "Lorg/springframework/http/client/ClientHttpResponse;", "req", "Lorg/springframework/http/HttpRequest;", "body", "", "execution", "Lorg/springframework/http/client/ClientHttpRequestExecution;", "token-validation-spring"})
public final class BearerTokenClientHttpRequestInterceptor
implements ClientHttpRequestInterceptor {
    @NotNull
    private final TokenValidationContextHolder holder;
    private final Logger log;

    public BearerTokenClientHttpRequestInterceptor(@NotNull TokenValidationContextHolder holder) {
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        this.holder = holder;
        this.log = LoggerFactory.getLogger(BearerTokenClientHttpRequestInterceptor.class);
    }

    @NotNull
    public ClientHttpResponse intercept(@NotNull HttpRequest req, @NotNull byte[] body, @NotNull ClientHttpRequestExecution execution) throws IOException {
        Intrinsics.checkNotNullParameter((Object)req, (String)"req");
        Intrinsics.checkNotNullParameter((Object)body, (String)"body");
        Intrinsics.checkNotNullParameter((Object)execution, (String)"execution");
        TokenValidationContext $this$intercept_u24lambda_u241 = this.holder.getTokenValidationContext();
        boolean bl = false;
        if ($this$intercept_u24lambda_u241.hasValidToken()) {
            this.log.debug("Adding tokens to Authorization header");
            req.getHeaders().add("Authorization", CollectionsKt.joinToString$default((Iterable)$this$intercept_u24lambda_u241.getIssuers(), null, null, null, (int)0, null, arg_0 -> BearerTokenClientHttpRequestInterceptor.intercept$lambda$1$lambda$0($this$intercept_u24lambda_u241, arg_0), (int)31, null));
        }
        ClientHttpResponse clientHttpResponse = execution.execute(req, body);
        Intrinsics.checkNotNullExpressionValue((Object)clientHttpResponse, (String)"execute(...)");
        return clientHttpResponse;
    }

    private static final CharSequence intercept$lambda$1$lambda$0(TokenValidationContext $this_apply, String it) {
        Intrinsics.checkNotNullParameter((Object)$this_apply, (String)"$this_apply");
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        JwtToken jwtToken = $this_apply.getJwtToken(it);
        return String.valueOf(jwtToken != null ? jwtToken.asBearer() : null);
    }
}

