/*
 * Decompiled with CFR 0.152.
 */
package no.nav.security.token.support.spring;

import com.nimbusds.jose.util.ResourceRetriever;
import jakarta.servlet.DispatcherType;
import jakarta.servlet.Filter;
import java.net.URL;
import java.util.EnumSet;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import no.nav.security.token.support.core.configuration.MultiIssuerConfiguration;
import no.nav.security.token.support.core.configuration.ProxyAwareResourceRetriever;
import no.nav.security.token.support.core.context.TokenValidationContextHolder;
import no.nav.security.token.support.core.validation.JwtTokenValidationHandler;
import no.nav.security.token.support.filter.JwtTokenExpiryFilter;
import no.nav.security.token.support.filter.JwtTokenValidationFilter;
import no.nav.security.token.support.spring.MultiIssuerProperties;
import no.nav.security.token.support.spring.SpringTokenValidationContextHolder;
import no.nav.security.token.support.spring.api.EnableJwtTokenValidation;
import no.nav.security.token.support.spring.validation.interceptor.BearerTokenClientHttpRequestInterceptor;
import no.nav.security.token.support.spring.validation.interceptor.JwtTokenHandlerInterceptor;
import no.nav.security.token.support.spring.validation.interceptor.SpringJwtTokenAnnotationHandler;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.web.servlet.FilterRegistrationBean;
import org.springframework.boot.web.servlet.ServletRegistrationBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.ImportAware;
import org.springframework.core.annotation.AnnotationAttributes;
import org.springframework.core.env.Environment;
import org.springframework.core.type.AnnotationMetadata;
import org.springframework.web.context.request.RequestContextListener;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.config.annotation.InterceptorRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;

@Configuration
@EnableConfigurationProperties(value={MultiIssuerProperties.class})
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u009e\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0017\u0018\u00002\u00020\u00012\u00020\u0002B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0017J\n\u0010\u0013\u001a\u0004\u0018\u00010\u0014H\u0012J\b\u0010\u0015\u001a\u00020\u0016H\u0012J\u001a\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u00122\b\b\u0001\u0010\u001a\u001a\u00020\u001bH\u0017J&\u0010\u001c\u001a\u0010\u0012\f\u0012\n \n*\u0004\u0018\u00010\u001e0\u001e0\u001d2\u0006\u0010\u001f\u001a\u00020\u001e2\u0006\u0010 \u001a\u00020!H\u0012J\u0018\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020'H\u0017J\b\u0010(\u001a\u00020)H\u0017J\b\u0010*\u001a\u00020+H\u0017J\u001e\u0010,\u001a\u0010\u0012\f\u0012\n \n*\u0004\u0018\u00010\u001e0\u001e0\u001d2\u0006\u0010\u001f\u001a\u00020\u0018H\u0017J(\u0010-\u001a\u0010\u0012\f\u0012\n \n*\u0004\u0018\u00010\u001e0\u001e0\u001d2\u0006\u0010\u001f\u001a\u00020.2\b\b\u0001\u0010 \u001a\u00020!H\u0017J\b\u0010/\u001a\u000200H\u0017J\u0010\u00101\u001a\u00020\f2\u0006\u00102\u001a\u000203H\u0016J\u0018\u00104\u001a\u00020.2\u0006\u00105\u001a\u00020#2\u0006\u0010\u0019\u001a\u00020\u0012H\u0017R\u000e\u0010\u0006\u001a\u00020\u0007X\u0092.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\b\u001a\n \n*\u0004\u0018\u00010\t0\tX\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00066"}, d2={"Lno/nav/security/token/support/spring/EnableJwtTokenValidationConfiguration;", "Lorg/springframework/web/servlet/config/annotation/WebMvcConfigurer;", "Lorg/springframework/context/annotation/ImportAware;", "env", "Lorg/springframework/core/env/Environment;", "(Lorg/springframework/core/env/Environment;)V", "attrs", "Lorg/springframework/core/annotation/AnnotationAttributes;", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "addInterceptors", "", "registry", "Lorg/springframework/web/servlet/config/annotation/InterceptorRegistry;", "bearerTokenClientHttpRequestInterceptor", "Lno/nav/security/token/support/spring/validation/interceptor/BearerTokenClientHttpRequestInterceptor;", "tokenValidationContextHolder", "Lno/nav/security/token/support/core/context/TokenValidationContextHolder;", "configuredProxy", "Ljava/net/URL;", "controllerInterceptor", "Lno/nav/security/token/support/spring/validation/interceptor/JwtTokenHandlerInterceptor;", "expiryFilter", "Lno/nav/security/token/support/filter/JwtTokenExpiryFilter;", "h", "threshold", "", "filterRegistrationBeanFor", "Lorg/springframework/boot/web/servlet/FilterRegistrationBean;", "Ljakarta/servlet/Filter;", "filter", "order", "", "multiIssuerConfiguration", "Lno/nav/security/token/support/core/configuration/MultiIssuerConfiguration;", "issuerProperties", "Lno/nav/security/token/support/spring/MultiIssuerProperties;", "resourceRetriever", "Lcom/nimbusds/jose/util/ResourceRetriever;", "oidcRequestContextHolder", "Lno/nav/security/token/support/spring/SpringTokenValidationContextHolder;", "oidcResourceRetriever", "Lno/nav/security/token/support/core/configuration/ProxyAwareResourceRetriever;", "oidcTokenExpiryFilterRegistrationBean", "oidcTokenValidationFilterRegistrationBean", "Lno/nav/security/token/support/filter/JwtTokenValidationFilter;", "requestContextListener", "Lorg/springframework/web/context/request/RequestContextListener;", "setImportMetadata", "meta", "Lorg/springframework/core/type/AnnotationMetadata;", "tokenValidationFilter", "config", "token-validation-spring"})
@SourceDebugExtension(value={"SMAP\nEnableJwtTokenValidationConfiguration.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EnableJwtTokenValidationConfiguration.kt\nno/nav/security/token/support/spring/EnableJwtTokenValidationConfiguration\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,101:1\n1#2:102\n*E\n"})
public class EnableJwtTokenValidationConfiguration
implements WebMvcConfigurer,
ImportAware {
    @NotNull
    private final Environment env;
    private final Logger log;
    private AnnotationAttributes attrs;

    public EnableJwtTokenValidationConfiguration(@NotNull Environment env) {
        Intrinsics.checkNotNullParameter((Object)env, (String)"env");
        this.env = env;
        this.log = LoggerFactory.getLogger(EnableJwtTokenValidationConfiguration.class);
    }

    public void addInterceptors(@NotNull InterceptorRegistry registry) {
        Intrinsics.checkNotNullParameter((Object)registry, (String)"registry");
        registry.addInterceptor((HandlerInterceptor)this.controllerInterceptor());
    }

    public void setImportMetadata(@NotNull AnnotationMetadata meta) {
        Intrinsics.checkNotNullParameter((Object)meta, (String)"meta");
        AnnotationAttributes annotationAttributes = AnnotationAttributes.fromMap((Map)meta.getAnnotationAttributes(EnableJwtTokenValidation.class.getName(), false));
        if (annotationAttributes == null) {
            throw new IllegalArgumentException("@EnableJwtTokenValidation is not present on importing class " + meta.getClassName());
        }
        this.attrs = annotationAttributes;
    }

    @Bean
    @NotNull
    public ProxyAwareResourceRetriever oidcResourceRetriever() {
        URL uRL = this.configuredProxy();
        Object object = this.env.getProperty("https.plaintext", Boolean.TYPE, (Object)false);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getProperty(...)");
        return new ProxyAwareResourceRetriever(uRL, ((Boolean)object).booleanValue());
    }

    @Bean
    @NotNull
    public MultiIssuerConfiguration multiIssuerConfiguration(@NotNull MultiIssuerProperties issuerProperties, @NotNull ResourceRetriever resourceRetriever) {
        Intrinsics.checkNotNullParameter((Object)issuerProperties, (String)"issuerProperties");
        Intrinsics.checkNotNullParameter((Object)resourceRetriever, (String)"resourceRetriever");
        return new MultiIssuerConfiguration(issuerProperties.getIssuer(), resourceRetriever);
    }

    @Bean
    @NotNull
    public SpringTokenValidationContextHolder oidcRequestContextHolder() {
        return new SpringTokenValidationContextHolder();
    }

    @Bean
    @NotNull
    public RequestContextListener requestContextListener() {
        return new RequestContextListener();
    }

    @Bean
    @NotNull
    public JwtTokenValidationFilter tokenValidationFilter(@NotNull MultiIssuerConfiguration config, @NotNull TokenValidationContextHolder h) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        Intrinsics.checkNotNullParameter((Object)h, (String)"h");
        return new JwtTokenValidationFilter(new JwtTokenValidationHandler(config), h);
    }

    @Bean
    @ConditionalOnProperty(value={"no.nav.security.jwt.expirythreshold"})
    @NotNull
    public JwtTokenExpiryFilter expiryFilter(@NotNull TokenValidationContextHolder h, @Value(value="${no.nav.security.jwt.expirythreshold}") long threshold) {
        Intrinsics.checkNotNullParameter((Object)h, (String)"h");
        return new JwtTokenExpiryFilter(h, threshold);
    }

    @Bean
    @ConditionalOnProperty(value={"no.nav.security.jwt.dont-propagate-bearertoken"}, matchIfMissing=true)
    @NotNull
    public BearerTokenClientHttpRequestInterceptor bearerTokenClientHttpRequestInterceptor(@NotNull TokenValidationContextHolder tokenValidationContextHolder) {
        Intrinsics.checkNotNullParameter((Object)tokenValidationContextHolder, (String)"tokenValidationContextHolder");
        return new BearerTokenClientHttpRequestInterceptor(tokenValidationContextHolder);
    }

    @Bean
    @NotNull
    public FilterRegistrationBean<Filter> oidcTokenValidationFilterRegistrationBean(@NotNull JwtTokenValidationFilter filter, @Value(value="${no.nav.security.jwt.tokenvalidationfilter.order:-2147483648}") int order) {
        Intrinsics.checkNotNullParameter((Object)filter, (String)"filter");
        return this.filterRegistrationBeanFor((Filter)filter, order);
    }

    @Bean
    @ConditionalOnProperty(value={"no.nav.security.jwt.expirythreshold"})
    @NotNull
    public FilterRegistrationBean<Filter> oidcTokenExpiryFilterRegistrationBean(@NotNull JwtTokenExpiryFilter filter) {
        Intrinsics.checkNotNullParameter((Object)filter, (String)"filter");
        return this.filterRegistrationBeanFor((Filter)filter, 2);
    }

    private FilterRegistrationBean<Filter> filterRegistrationBeanFor(Filter filter, int order) {
        FilterRegistrationBean filterRegistrationBean;
        FilterRegistrationBean it = filterRegistrationBean = new FilterRegistrationBean(filter, new ServletRegistrationBean[0]);
        boolean bl = false;
        this.log.info("Registering " + filter.getClass().getSimpleName());
        FilterRegistrationBean $this$filterRegistrationBeanFor_u24lambda_u241 = filterRegistrationBean;
        boolean bl2 = false;
        $this$filterRegistrationBeanFor_u24lambda_u241.setOrder(order);
        $this$filterRegistrationBeanFor_u24lambda_u241.setDispatcherTypes(EnumSet.of((Enum)DispatcherType.REQUEST, (Enum)DispatcherType.FORWARD, (Enum)DispatcherType.ASYNC));
        return filterRegistrationBean;
    }

    private JwtTokenHandlerInterceptor controllerInterceptor() {
        AnnotationAttributes annotationAttributes = this.attrs;
        if (annotationAttributes == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"attrs");
            annotationAttributes = null;
        }
        return new JwtTokenHandlerInterceptor(annotationAttributes, new SpringJwtTokenAnnotationHandler(new SpringTokenValidationContextHolder()));
    }

    private URL configuredProxy() {
        URL uRL;
        URL uRL2 = (URL)this.env.getProperty(this.env.getProperty("http.proxy.parametername", "http.proxy"), URL.class);
        if (uRL2 != null) {
            URL uRL3;
            URL $this$configuredProxy_u24lambda_u242 = uRL3 = uRL2;
            boolean bl = false;
            String string = this.env.getProperty("nais.cluster.name", "local");
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getProperty(...)");
            if (StringsKt.contains$default((CharSequence)string, (CharSequence)"gcp", (boolean)false, (int)2, null)) {
                this.log.warn("You have enabled proxying in GCP, this is probably not what you want");
            }
            uRL = uRL3;
        } else {
            uRL = null;
        }
        return uRL;
    }
}

