/*
 * Decompiled with CFR 0.152.
 */
package no.nav.security.token.support.test.spring;

import com.nimbusds.jose.jwk.JWKSet;
import com.nimbusds.jose.util.IOUtils;
import com.nimbusds.jwt.SignedJWT;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import no.nav.security.token.support.core.api.Unprotected;
import no.nav.security.token.support.test.JwkGenerator;
import no.nav.security.token.support.test.JwtTokenGenerator;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Deprecated
@RestController
@RequestMapping(value={"/local"})
public class TokenGeneratorController {
    @Unprotected
    @GetMapping
    public TokenEndpoint[] endpoints(HttpServletRequest request) {
        String base = request.getRequestURL().toString();
        return new TokenEndpoint[]{new TokenEndpoint("Get JWT as serialized string", base + "/jwt", "subject"), new TokenEndpoint("Get JWT as SignedJWT object with claims", base + "/claims", "subject"), new TokenEndpoint("Add JWT as a cookie, (optional) redirect to secured uri", base + "/cookie", "subject", "redirect", "cookiename"), new TokenEndpoint("Get JWKS used to sign token", base + "/jwks", new String[0]), new TokenEndpoint("Get JWKS used to sign token as JWKSet object", base + "/jwkset", new String[0]), new TokenEndpoint("Get token issuer metadata (ref oidc .well-known)", base + "/metadata", new String[0])};
    }

    @Unprotected
    @GetMapping(value={"/jwt"})
    public String issueToken(@RequestParam(value="subject", defaultValue="12345678910") String subject) {
        return JwtTokenGenerator.createSignedJWT(subject).serialize();
    }

    @Unprotected
    @GetMapping(value={"/claims"})
    public SignedJWT jwtClaims(@RequestParam(value="subject", defaultValue="12345678910") String subject) {
        return JwtTokenGenerator.createSignedJWT(subject);
    }

    @Unprotected
    @GetMapping(value={"/cookie"})
    public Cookie addCookie(@RequestParam(value="subject", defaultValue="12345678910") String subject, @RequestParam(value="cookiename", defaultValue="localhost-idtoken") String cookieName, @RequestParam(value="redirect", required=false) String redirect, @RequestParam(value="expiry", required=false) String expiry, HttpServletRequest request, HttpServletResponse response) throws IOException {
        long expiryTime = expiry != null ? Long.parseLong(expiry) : 12960000L;
        SignedJWT token = JwtTokenGenerator.createSignedJWT(subject, expiryTime);
        Cookie cookie = new Cookie(cookieName, token.serialize());
        cookie.setDomain("localhost");
        cookie.setPath("/");
        response.addCookie(cookie);
        if (redirect != null) {
            response.sendRedirect(redirect);
            return null;
        }
        return cookie;
    }

    @Unprotected
    @GetMapping(value={"/jwks"})
    public String jwks() throws IOException {
        return IOUtils.readInputStreamToString((InputStream)this.getClass().getResourceAsStream("/jwkset.json"), (Charset)Charset.defaultCharset());
    }

    @Unprotected
    @GetMapping(value={"/jwkset"})
    public JWKSet jwkSet() {
        return JwkGenerator.getJWKSet();
    }

    @Unprotected
    @GetMapping(value={"/metadata"})
    public String metadata() throws IOException {
        return IOUtils.readInputStreamToString((InputStream)this.getClass().getResourceAsStream("/metadata.json"), (Charset)Charset.defaultCharset());
    }

    static class TokenEndpoint {
        final String desc;
        final String uri;
        final String[] params;

        TokenEndpoint(String desc, String uri, String ... params) {
            this.desc = desc;
            this.uri = uri;
            this.params = params;
        }

        public String getDesc() {
            return this.desc;
        }

        public String getUri() {
            return this.uri;
        }

        public String[] getParams() {
            return this.params;
        }
    }
}

