/*
 * Decompiled with CFR 0.152.
 */
package no.nav.security.token.support.test;

import com.nimbusds.jose.JOSEException;
import com.nimbusds.jose.JOSEObjectType;
import com.nimbusds.jose.JWSAlgorithm;
import com.nimbusds.jose.JWSHeader;
import com.nimbusds.jose.JWSSigner;
import com.nimbusds.jose.crypto.RSASSASigner;
import com.nimbusds.jose.jwk.RSAKey;
import com.nimbusds.jwt.JWTClaimsSet;
import com.nimbusds.jwt.SignedJWT;
import java.util.Date;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import no.nav.security.token.support.test.JwkGenerator;

@Deprecated(since="1.3.0")
public class JwtTokenGenerator {
    public static final String ISS = "iss-localhost";
    public static final String AUD = "aud-localhost";
    public static final String ACR = "Level4";
    public static final long EXPIRY = 12960000L;

    private JwtTokenGenerator() {
    }

    public static String signedJWTAsString(String subject) {
        return JwtTokenGenerator.createSignedJWT(subject).serialize();
    }

    public static SignedJWT createSignedJWT(String subject) {
        return JwtTokenGenerator.createSignedJWT(subject, 12960000L);
    }

    public static SignedJWT createSignedJWT(String subject, long expiryInMinutes) {
        JWTClaimsSet claimsSet = JwtTokenGenerator.buildClaimSet(subject, ISS, AUD, ACR, TimeUnit.MINUTES.toMillis(expiryInMinutes));
        return JwtTokenGenerator.createSignedJWT(JwkGenerator.getDefaultRSAKey(), claimsSet);
    }

    public static SignedJWT createSignedJWT(JWTClaimsSet claimsSet) {
        return JwtTokenGenerator.createSignedJWT(JwkGenerator.getDefaultRSAKey(), claimsSet);
    }

    public static JWTClaimsSet buildClaimSet(String subject, String issuer, String audience, String authLevel, long expiry) {
        Date now = new Date();
        return new JWTClaimsSet.Builder().subject(subject).issuer(issuer).audience(audience).jwtID(UUID.randomUUID().toString()).claim("acr", (Object)authLevel).claim("ver", (Object)"1.0").claim("nonce", (Object)"myNonce").claim("auth_time", (Object)now).notBeforeTime(now).issueTime(now).expirationTime(new Date(now.getTime() + expiry)).build();
    }

    public static SignedJWT createSignedJWT(RSAKey rsaJwk, JWTClaimsSet claimsSet) {
        try {
            JWSHeader.Builder header = new JWSHeader.Builder(JWSAlgorithm.RS256).keyID(rsaJwk.getKeyID()).type(JOSEObjectType.JWT);
            SignedJWT signedJWT = new SignedJWT(header.build(), claimsSet);
            RSASSASigner signer = new RSASSASigner(rsaJwk.toPrivateKey());
            signedJWT.sign((JWSSigner)signer);
            return signedJWT;
        }
        catch (JOSEException e) {
            throw new RuntimeException(e);
        }
    }
}

