/*
 * Decompiled with CFR 0.152.
 */
package no.obje.jdbcmiddleware.domain;

import java.sql.Date;
import java.sql.ResultSet;
import java.time.LocalDate;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Supplier;
import no.obje.jdbcmiddleware.util.ExceptionUtil;

public class QueryResult {
    private final ResultSet resultSet;

    public QueryResult(ResultSet resultSet) {
        this.resultSet = Objects.requireNonNull(resultSet);
    }

    public String requireString(String columnName) {
        return this.getString(columnName).orElseThrow(this.getMissingColumnException(columnName));
    }

    public Optional<String> getString(String columnName) {
        return Optional.ofNullable(ExceptionUtil.soften(() -> this.resultSet.getString(columnName)));
    }

    public Integer requireInteger(String columnName) {
        return this.getInteger(columnName).orElseThrow(this.getMissingColumnException(columnName));
    }

    public Optional<Integer> getInteger(String columnName) {
        return this.emptyOrValueIfNotWasNull(rs -> ExceptionUtil.soften(() -> rs.getInt(columnName)));
    }

    public Double requireDouble(String columnName) {
        return this.getDouble(columnName).orElseThrow(this.getMissingColumnException(columnName));
    }

    public Optional<Double> getDouble(String columnName) {
        return this.emptyOrValueIfNotWasNull(rs -> ExceptionUtil.soften(() -> rs.getDouble(columnName)));
    }

    public Long requireLong(String columnName) {
        return this.getLong(columnName).orElseThrow(this.getMissingColumnException(columnName));
    }

    public Optional<Long> getLong(String columnName) {
        return this.emptyOrValueIfNotWasNull(rs -> ExceptionUtil.soften(() -> rs.getLong(columnName)));
    }

    public boolean requireBoolean(String columnName) {
        return this.getBoolean(columnName).orElseThrow(this.getMissingColumnException(columnName));
    }

    public Optional<Boolean> getBoolean(String columnName) {
        return this.emptyOrValueIfNotWasNull(rs -> ExceptionUtil.soften(() -> rs.getBoolean(columnName)));
    }

    public Optional<LocalDate> getDate(String columnName) {
        return Optional.ofNullable(ExceptionUtil.soften(() -> this.resultSet.getDate(columnName))).map(Date::toLocalDate);
    }

    public LocalDate requireDate(String columnName) {
        return this.getDate(columnName).orElseThrow(this.getMissingColumnException(columnName));
    }

    private Supplier<IllegalStateException> getMissingColumnException(String columnName) {
        return () -> new IllegalStateException("Required column with name '" + columnName + "' was not present");
    }

    private <T> Optional<T> emptyOrValueIfNotWasNull(Function<ResultSet, T> function) {
        T value = function.apply(this.resultSet);
        return ExceptionUtil.soften(this.resultSet::wasNull) != false ? Optional.empty() : Optional.of(value);
    }

    public ResultSet getResultSet() {
        return this.resultSet;
    }
}

