/*
 * Decompiled with CFR 0.152.
 */
package no.obje.jdbcmiddleware.service;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.Objects;
import javax.sql.DataSource;
import no.obje.jdbcmiddleware.domain.ConnectionCallback;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConnectionManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(ConnectionManager.class);
    private final DataSource dataSource;
    private ThreadLocal<Connection> transactionConnection = new ThreadLocal();

    public ConnectionManager(DataSource dataSource) {
        this.dataSource = Objects.requireNonNull(dataSource);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public <R> R doWithConnection(ConnectionCallback<R> callback) {
        if (this.transactionConnection.get() != null) {
            return callback.run(this.transactionConnection.get());
        }
        try (Connection connection = this.dataSource.getConnection();){
            R r = callback.run(connection);
            return r;
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    public void startTransaction() {
        Connection connection;
        LOGGER.debug("Starting new transaction");
        if (this.transactionConnection.get() != null) {
            throw new IllegalStateException("Unable to start transaction, transaction already in progress");
        }
        try {
            connection = this.dataSource.getConnection();
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
        try {
            connection.setAutoCommit(false);
            this.transactionConnection.set(connection);
        }
        catch (SQLException e) {
            try {
                connection.close();
            }
            catch (SQLException e1) {
                throw new RuntimeException("Unable to close connection", e);
            }
            throw new RuntimeException(e);
        }
    }

    public void commitTransaction() {
        LOGGER.debug("Committing transaction");
        Connection connection = this.transactionConnection.get();
        if (connection == null) {
            throw new IllegalStateException("Unable to commit transaction with missing connection");
        }
        try {
            connection.commit();
            connection.close();
        }
        catch (SQLException e) {
            try {
                connection.close();
            }
            catch (SQLException e1) {
                throw new RuntimeException("Unable to close connection", e1);
            }
            throw new RuntimeException("Unable to commit transaction", e);
        }
        finally {
            this.transactionConnection.remove();
        }
    }

    public void rollbackTransaction() {
        LOGGER.debug("Rolling back transaction");
        Connection connection = this.transactionConnection.get();
        if (connection == null) {
            throw new IllegalStateException("Unable to rollback transaction with missing connection");
        }
        try {
            connection.rollback();
            connection.close();
        }
        catch (SQLException e) {
            try {
                connection.close();
            }
            catch (SQLException e1) {
                throw new RuntimeException("Unable to close connection", e1);
            }
            throw new RuntimeException("Failed to rollback transaction", e);
        }
        finally {
            this.transactionConnection.remove();
        }
    }

    public boolean isTransactionInProgress() {
        return this.transactionConnection.get() != null;
    }
}

