/*
 * Decompiled with CFR 0.152.
 */
package no.obje.jdbcmiddleware.service;

import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLSyntaxErrorException;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.sql.DataSource;
import no.obje.jdbcmiddleware.domain.QueryResult;
import no.obje.jdbcmiddleware.domain.RowMapper;
import no.obje.jdbcmiddleware.domain.StatementCallback;
import no.obje.jdbcmiddleware.exception.MalformedSqlException;
import no.obje.jdbcmiddleware.service.ConnectionManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JdbcService {
    private static final Logger LOGGER = LoggerFactory.getLogger(JdbcService.class);
    private final ConnectionManager connectionManager;

    public JdbcService(ConnectionManager connectionManager) {
        this.connectionManager = Objects.requireNonNull(connectionManager);
    }

    public JdbcService(DataSource dataSource) {
        this.connectionManager = new ConnectionManager(Objects.requireNonNull(dataSource));
    }

    public <T> Optional<T> queryForSingle(String sql, RowMapper<T> rowMapper, Object ... args) {
        return this.connectionManager.doWithConnection(connection -> this.withStatement(connection, sql, Arrays.asList(args), statement -> this.executeSingle(statement, rowMapper)));
    }

    public <T> List<T> queryForList(String sql, RowMapper<T> rowMapper, Object ... args) {
        return this.connectionManager.doWithConnection(connection -> this.withStatement(connection, sql, Arrays.asList(args), statement -> this.executeList(statement, rowMapper)));
    }

    public Long insertAndReturnKey(String sql, String keyColumn, Object ... args) {
        return this.connectionManager.doWithConnection(connection -> this.withStatementAndReturnGeneratedKeys(connection, sql, Arrays.asList(args), statement -> this.executeInsert(statement, keyColumn)));
    }

    public void insert(String sql, Object ... args) {
        this.connectionManager.doWithConnection(connection -> this.withStatement(connection, sql, Arrays.asList(args), statement -> {
            this.executeInsert(statement);
            return null;
        }));
    }

    public void updateSingle(String sql, Object ... args) {
        this.connectionManager.doWithConnection(connection -> this.withStatement(connection, sql, Arrays.asList(args), statement -> {
            try {
                int rowsAffected = statement.executeUpdate();
                if (rowsAffected > 1) {
                    throw new IllegalStateException("More than one row was affected by query: '" + sql + "'");
                }
                if (rowsAffected < 1) {
                    throw new IllegalStateException("No row was affected by query: '" + sql + "'");
                }
            }
            catch (SQLException e) {
                throw new RuntimeException(e);
            }
            return null;
        }));
    }

    public Integer update(String sql, Object ... args) {
        return this.connectionManager.doWithConnection(connection -> this.withStatement(connection, sql, Arrays.asList(args), statement -> {
            try {
                return statement.executeUpdate();
            }
            catch (SQLException e) {
                throw new RuntimeException(e);
            }
        }));
    }

    public void deleteSingle(String sql, Object ... args) {
        this.updateSingle(sql, args);
    }

    public Integer delete(String sql, Object ... args) {
        return this.update(sql, args);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private <R> R withStatement(Connection connection, String sql, List<Object> args, StatementCallback<R> callback) {
        if (sql == null) throw new IllegalArgumentException("SQL String cannot be blank or null");
        if (sql.isEmpty()) {
            throw new IllegalArgumentException("SQL String cannot be blank or null");
        }
        LOGGER.debug("Executing query: '{}' with values {}", (Object)sql, args);
        try (PreparedStatement statement = connection.prepareStatement(sql);){
            R result = this.executeStatement(statement, args, callback);
            LOGGER.info("Executed query: '{}' with values {}", (Object)sql, args);
            R r = result;
            return r;
        }
        catch (SQLSyntaxErrorException e) {
            throw new MalformedSqlException(e);
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private <R> R withStatementAndReturnGeneratedKeys(Connection connection, String sql, List<Object> args, StatementCallback<R> callback) {
        if (sql == null) throw new IllegalArgumentException("SQL String cannot be blank or null");
        if (sql.isEmpty()) {
            throw new IllegalArgumentException("SQL String cannot be blank or null");
        }
        LOGGER.debug("Executing query: '{}' with values {}", (Object)sql, args);
        try (PreparedStatement statement = connection.prepareStatement(sql, 1);){
            R result = this.executeStatement(statement, args, callback);
            LOGGER.info("Executed query: '{}' with values {}", (Object)sql, args);
            R r = result;
            return r;
        }
        catch (SQLSyntaxErrorException e) {
            throw new MalformedSqlException(e);
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    private <R> R executeStatement(PreparedStatement statement, List<Object> args, StatementCallback<R> callback) {
        for (int i = 1; i < args.size() + 1; ++i) {
            this.setArg(statement, i, args.get(i - 1));
        }
        return callback.run(statement);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private <R> Optional<R> executeSingle(PreparedStatement preparedStatement, RowMapper<R> rowMapper) {
        if (rowMapper == null) {
            throw new IllegalArgumentException("Row mapper must be specified");
        }
        try (ResultSet resultSet = preparedStatement.executeQuery();){
            if (resultSet.next()) {
                Optional<R> optional = Optional.of(rowMapper.mapRow(new QueryResult(resultSet)));
                return optional;
            }
            Optional optional = Optional.empty();
            return optional;
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private <R> List<R> executeList(PreparedStatement preparedStatement, RowMapper<R> rowMapper) {
        if (rowMapper == null) {
            throw new IllegalArgumentException("Row mapper must be specified");
        }
        try (ResultSet resultSet = preparedStatement.executeQuery();){
            ArrayList<R> resultList = new ArrayList<R>();
            while (resultSet.next()) {
                QueryResult queryResult = new QueryResult(resultSet);
                resultList.add(rowMapper.mapRow(queryResult));
            }
            ArrayList<R> arrayList = resultList;
            return arrayList;
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    private Long executeInsert(PreparedStatement statement, String keyColumn) {
        if (keyColumn == null || keyColumn.isEmpty()) {
            throw new IllegalArgumentException("Key column must be specified");
        }
        try {
            int numberOfRowsAffected = statement.executeUpdate();
            if (numberOfRowsAffected <= 0) {
                throw new IllegalStateException("No rows was inserted");
            }
            ResultSet generatedKeys = statement.getGeneratedKeys();
            if (generatedKeys.next()) {
                try {
                    return generatedKeys.getLong(keyColumn);
                }
                catch (SQLException e) {
                    LOGGER.warn("Unable to find generated key for column '{}'", (Object)keyColumn);
                    throw new MalformedSqlException(e);
                }
            }
            throw new IllegalStateException("No ID (key) was generated");
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    private void executeInsert(PreparedStatement statement) {
        try {
            int numberOfRowsAffected = statement.executeUpdate();
            if (numberOfRowsAffected <= 0) {
                throw new IllegalStateException("No rows was inserted");
            }
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    private void setArg(PreparedStatement statement, int index, Object arg) {
        block7: {
            try {
                if (arg instanceof Integer) {
                    statement.setInt(index, (Integer)arg);
                    break block7;
                }
                if (arg instanceof Boolean) {
                    statement.setBoolean(index, (Boolean)arg);
                    break block7;
                }
                if (arg instanceof Long) {
                    statement.setLong(index, (Long)arg);
                    break block7;
                }
                if (arg instanceof LocalDate) {
                    statement.setDate(index, Date.valueOf((LocalDate)arg));
                    break block7;
                }
                if (arg instanceof String) {
                    statement.setString(index, (String)arg);
                    break block7;
                }
                throw new RuntimeException("Unsupported argument type: " + arg.getClass());
            }
            catch (SQLException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

