/*
 * Decompiled with CFR 0.152.
 */
package no.obje.jdbcmiddleware.service;

import java.util.Objects;
import java.util.concurrent.Callable;
import no.obje.jdbcmiddleware.service.ConnectionManager;

public class TransactionManager {
    private final ConnectionManager connectionManager;

    public TransactionManager(ConnectionManager connectionManager) {
        this.connectionManager = Objects.requireNonNull(connectionManager);
    }

    public void doInTransaction(Runnable runnable) {
        boolean transactionInProgress = this.connectionManager.isTransactionInProgress();
        if (!transactionInProgress) {
            this.connectionManager.startTransaction();
        }
        try {
            runnable.run();
            if (!transactionInProgress) {
                this.connectionManager.commitTransaction();
            }
        }
        catch (Throwable throwable) {
            if (!transactionInProgress) {
                this.connectionManager.rollbackTransaction();
            }
            throw new RuntimeException("Something went wrong during execution, rolled back transaction");
        }
    }

    public <T> T doInTransaction(Callable<T> callable) {
        boolean transactionInProgress = this.connectionManager.isTransactionInProgress();
        if (!transactionInProgress) {
            this.connectionManager.startTransaction();
        }
        try {
            T result = callable.call();
            if (!transactionInProgress) {
                this.connectionManager.commitTransaction();
            }
            return result;
        }
        catch (Throwable throwable) {
            if (!transactionInProgress) {
                this.connectionManager.rollbackTransaction();
            }
            throw new RuntimeException("Something went wrong during execution, rolled back transaction");
        }
    }
}

