/*
 * Decompiled with CFR 0.152.
 */
package no.oslomet.aaas.utils;

import java.util.Set;
import org.deidentifier.arx.ARXPopulationModel;
import org.deidentifier.arx.ARXResult;
import org.deidentifier.arx.risk.RiskModelPopulationUniqueness;
import org.springframework.stereotype.Component;

@Component
public class ARXResponseAnalyser {
    public double getResponseLowestProsecutorRisk(ARXResult result, ARXPopulationModel pModel) {
        return result.getOutput().getRiskEstimator(pModel).getSampleBasedReidentificationRisk().getLowestRisk();
    }

    public double getResponseRecordsAffectByRisk(ARXResult result, ARXPopulationModel pModel, double risk) {
        return result.getOutput().getRiskEstimator(pModel).getSampleBasedRiskDistribution().getFractionOfRecordsAtRisk(risk);
    }

    public Double getResponseAverageProsecutorRisk(ARXResult result, ARXPopulationModel pModel) {
        return result.getOutput().getRiskEstimator(pModel).getSampleBasedReidentificationRisk().getAverageRisk();
    }

    public double getResponseHighestProsecutorRisk(ARXResult result, ARXPopulationModel pModel) {
        return result.getOutput().getRiskEstimator(pModel).getSampleBasedReidentificationRisk().getHighestRisk();
    }

    public double getResponseEstimatedProsecutorRisk(ARXResult result, ARXPopulationModel pModel) {
        return result.getOutput().getRiskEstimator(pModel).getSampleBasedReidentificationRisk().getEstimatedProsecutorRisk();
    }

    public double getResponseEstimatedJournalistRisk(ARXResult result, ARXPopulationModel pModel) {
        return result.getOutput().getRiskEstimator(pModel).getSampleBasedReidentificationRisk().getEstimatedJournalistRisk();
    }

    public double getResponseEstimatedMarketerRisk(ARXResult result, ARXPopulationModel pModel) {
        return result.getOutput().getRiskEstimator(pModel).getSampleBasedReidentificationRisk().getEstimatedMarketerRisk();
    }

    public double getResponseSampleUniques(ARXResult result, ARXPopulationModel pModel) {
        return result.getOutput().getRiskEstimator(pModel).getSampleBasedUniquenessRisk().getFractionOfUniqueTuples();
    }

    public double getResponsePopulationUniques(ARXResult result, ARXPopulationModel pModel) {
        return result.getOutput().getRiskEstimator(pModel).getPopulationBasedUniquenessRisk().getFractionOfUniqueTuples(this.getResponsePopulationModel(result, pModel));
    }

    public RiskModelPopulationUniqueness.PopulationUniquenessModel getResponsePopulationModel(ARXResult result, ARXPopulationModel pModel) {
        return result.getOutput().getRiskEstimator(pModel).getPopulationBasedUniquenessRisk().getPopulationUniquenessModel();
    }

    public Set<String> getResponseQuasiIdentifiers(ARXResult result) {
        return result.getDataDefinition().getQuasiIdentifyingAttributes();
    }

    public String getResponseAnalysisData(ARXResult result, ARXPopulationModel pModel) {
        return "Measure: Value;[%]\nLowest risk;" + this.getResponseLowestProsecutorRisk(result, pModel) * 100.0 + "%\nRecords affected by lowest risk;" + this.getResponseRecordsAffectByRisk(result, pModel, this.getResponseLowestProsecutorRisk(result, pModel)) * 100.0 + "%\nAverage prosecutor risk;" + this.getResponseAverageProsecutorRisk(result, pModel) * 100.0 + "%\nHighest prosecutor risk;" + this.getResponseHighestProsecutorRisk(result, pModel) * 100.0 + "%\nRecord affected by highest risk;" + this.getResponseRecordsAffectByRisk(result, pModel, this.getResponseHighestProsecutorRisk(result, pModel)) * 100.0 + "%\nEstimated prosecutor risk;" + this.getResponseEstimatedProsecutorRisk(result, pModel) * 100.0 + "%\nEstimated prosecutor risk;" + this.getResponseEstimatedProsecutorRisk(result, pModel) * 100.0 + "%\nEstimated journalist risk;" + this.getResponseEstimatedJournalistRisk(result, pModel) * 100.0 + "%\nEstimated marketer risk;" + this.getResponseEstimatedMarketerRisk(result, pModel) * 100.0 + "%\nSample uniques: " + this.getResponseSampleUniques(result, pModel) * 100.0 + "%\nPopulation uniques: " + this.getResponsePopulationUniques(result, pModel) * 100.0 + "%\nPopulation model: " + this.getResponsePopulationModel(result, pModel) + "\nQuasi-identifiers: " + this.getResponseQuasiIdentifiers(result) + "\n";
    }
}

