/*
 * Decompiled with CFR 0.152.
 */
package no.oslomet.aaas.analyser;

import java.util.Map;
import no.oslomet.aaas.analyser.Analyser;
import no.oslomet.aaas.model.AnalysationPayload;
import no.oslomet.aaas.model.AnalysisResult;
import no.oslomet.aaas.utils.ARXPayloadAnalyser;
import no.oslomet.aaas.utils.ARXWrapper;
import org.deidentifier.arx.ARXPopulationModel;
import org.deidentifier.arx.Data;
import org.deidentifier.arx.DataHandle;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ARXAnalyser
implements Analyser {
    private final ARXWrapper arxWrapper;
    private final ARXPayloadAnalyser arxPayloadAnalyser;

    @Autowired
    public ARXAnalyser(ARXWrapper wrapper, ARXPayloadAnalyser analyser) {
        this.arxWrapper = wrapper;
        this.arxPayloadAnalyser = analyser;
    }

    public AnalysisResult analyse(AnalysationPayload payload) {
        Data data = this.arxWrapper.setData(payload.getData());
        this.arxWrapper.setSensitivityModels(data, payload);
        DataHandle dataToAnalyse = data.getHandle();
        ARXPopulationModel pModel = ARXPopulationModel.create((int)data.getHandle().getNumRows(), (double)0.01);
        Map analasysMetrics = this.arxPayloadAnalyser.getPayloadAnalysisData(dataToAnalyse, pModel);
        return new AnalysisResult(analasysMetrics);
    }
}

