/*
 * Decompiled with CFR 0.152.
 */
package no.oslomet.aaas.utils;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import no.oslomet.aaas.model.AnalysationPayload;
import no.oslomet.aaas.model.AnonymizationPayload;
import no.oslomet.aaas.model.AttributeTypeModel;
import no.oslomet.aaas.model.PrivacyModel;
import no.oslomet.aaas.utils.ARXWrapper;
import org.deidentifier.arx.ARXAnonymizer;
import org.deidentifier.arx.ARXConfiguration;
import org.deidentifier.arx.ARXResult;
import org.deidentifier.arx.AttributeType;
import org.deidentifier.arx.Data;
import org.deidentifier.arx.DataHandle;
import org.deidentifier.arx.criteria.DistinctLDiversity;
import org.deidentifier.arx.criteria.EntropyLDiversity;
import org.deidentifier.arx.criteria.KAnonymity;
import org.deidentifier.arx.criteria.PrivacyCriterion;
import org.deidentifier.arx.criteria.RecursiveCLDiversity;
import org.springframework.stereotype.Component;

@Component
public class ARXWrapper {
    public static final char CSV_SEPERATOR_CHAR = ',';
    final String COLUMNNAME = "column_name";

    public Data setData(String rawdata) {
        Data data = null;
        try {
            ByteArrayInputStream stream = new ByteArrayInputStream(rawdata.getBytes(StandardCharsets.UTF_8));
            data = Data.create((InputStream)stream, (Charset)Charset.defaultCharset(), (char)',');
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return data;
    }

    public ARXConfiguration setSuppressionLimit(ARXConfiguration config) {
        config.setSuppressionLimit(0.02);
        return config;
    }

    public Data setSensitivityModels(Data data, AnonymizationPayload payload) {
        for (Map.Entry entry : payload.getMetaData().getAttributeTypeList().entrySet()) {
            data.getDefinition().setAttributeType((String)entry.getKey(), ((AttributeTypeModel)entry.getValue()).getAttributeType());
        }
        return data;
    }

    public Data setSensitivityModels(Data data, AnalysationPayload analysationPayload) {
        for (Map.Entry entry : analysationPayload.getAttributeTypes().entrySet()) {
            data.getDefinition().setAttributeType((String)entry.getKey(), ((AttributeTypeModel)entry.getValue()).getAttributeType());
        }
        return data;
    }

    public ARXConfiguration setPrivacyModels(ARXConfiguration config, AnonymizationPayload payload) {
        for (Map.Entry entry : payload.getMetaData().getModels().entrySet()) {
            config.addPrivacyModel(this.getPrivacyModel((PrivacyModel)entry.getKey(), (Map)entry.getValue()));
        }
        return config;
    }

    public Data setHierarchies(Data data, AnonymizationPayload payload) {
        for (Map.Entry entry : payload.getMetaData().getHierarchy().entrySet()) {
            AttributeType.Hierarchy hierarchy = AttributeType.Hierarchy.create((String[][])((String[][])entry.getValue()));
            data.getDefinition().setAttributeType((String)entry.getKey(), (AttributeType)hierarchy);
        }
        return data;
    }

    public PrivacyCriterion getPrivacyModel(PrivacyModel model, Map<String, String> params) {
        switch (1.$SwitchMap$no$oslomet$aaas$model$PrivacyModel[model.ordinal()]) {
            case 1: {
                return new KAnonymity(Integer.parseInt(params.get("k")));
            }
            case 2: {
                return new DistinctLDiversity(params.get("column_name"), Integer.parseInt(params.get("l")));
            }
            case 3: {
                return new EntropyLDiversity(params.get("column_name"), (double)Integer.parseInt(params.get("l")), EntropyLDiversity.EntropyEstimator.SHANNON);
            }
            case 4: {
                return new EntropyLDiversity(params.get("column_name"), (double)Integer.parseInt(params.get("l")), EntropyLDiversity.EntropyEstimator.GRASSBERGER);
            }
            case 5: {
                return new RecursiveCLDiversity(params.get("column_name"), (double)Integer.parseInt(params.get("l")), Integer.parseInt(params.get("c")));
            }
        }
        throw new RuntimeException(model.getName() + " Privacy Model not supported");
    }

    public ARXAnonymizer setAnonymizer(ARXAnonymizer anonymizer) {
        anonymizer.setMaximumSnapshotSizeDataset(0.2);
        anonymizer.setMaximumSnapshotSizeSnapshot(0.2);
        anonymizer.setHistorySize(200);
        return anonymizer;
    }

    public ARXResult anonymize(ARXAnonymizer anonymizer, ARXConfiguration config, AnonymizationPayload payload) throws IOException {
        Data data = this.setData(payload.getData());
        data = this.setSensitivityModels(data, payload);
        data = this.setHierarchies(data, payload);
        config = this.setSuppressionLimit(config);
        config = this.setPrivacyModels(config, payload);
        anonymizer = this.setAnonymizer(anonymizer);
        return anonymizer.anonymize(data, config);
    }

    public String getAnonymizeData(ARXResult result) throws IOException {
        DataHandle handle = result.getOutput();
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        handle.save((OutputStream)outputStream, ',');
        return new String(outputStream.toByteArray());
    }
}

