/*
 * Decompiled with CFR 0.152.
 */
package no.oslomet.aaas.utils;

import java.util.Map;
import no.oslomet.aaas.exception.AaaSRuntimeException;
import no.oslomet.aaas.model.AnonymizationPayload;
import no.oslomet.aaas.model.PrivacyModel;
import no.oslomet.aaas.utils.ARXConfigurationSetter;
import org.deidentifier.arx.ARXConfiguration;
import org.deidentifier.arx.criteria.DistinctLDiversity;
import org.deidentifier.arx.criteria.EntropyLDiversity;
import org.deidentifier.arx.criteria.KAnonymity;
import org.deidentifier.arx.criteria.PrivacyCriterion;
import org.deidentifier.arx.criteria.RecursiveCLDiversity;
import org.springframework.stereotype.Component;

@Component
public class ARXConfigurationSetter {
    private static final String COLUMNNAME = "column_name";

    public ARXConfiguration setSuppressionLimit(ARXConfiguration config) {
        config.setSuppressionLimit(0.02);
        return config;
    }

    public ARXConfiguration setPrivacyModels(ARXConfiguration config, AnonymizationPayload payload) {
        for (Map.Entry entry : payload.getMetaData().getModels().entrySet()) {
            config.addPrivacyModel(this.getPrivacyModel((PrivacyModel)entry.getKey(), (Map)entry.getValue()));
        }
        return config;
    }

    private PrivacyCriterion getPrivacyModel(PrivacyModel model, Map<String, String> params) {
        switch (1.$SwitchMap$no$oslomet$aaas$model$PrivacyModel[model.ordinal()]) {
            case 1: {
                return new KAnonymity(Integer.parseInt(params.get("k")));
            }
            case 2: {
                return new DistinctLDiversity(params.get(COLUMNNAME), Integer.parseInt(params.get("l")));
            }
            case 3: {
                return new EntropyLDiversity(params.get(COLUMNNAME), (double)Integer.parseInt(params.get("l")), EntropyLDiversity.EntropyEstimator.SHANNON);
            }
            case 4: {
                return new EntropyLDiversity(params.get(COLUMNNAME), (double)Integer.parseInt(params.get("l")), EntropyLDiversity.EntropyEstimator.GRASSBERGER);
            }
            case 5: {
                return new RecursiveCLDiversity(params.get(COLUMNNAME), (double)Integer.parseInt(params.get("l")), Integer.parseInt(params.get("c")));
            }
        }
        throw new AaaSRuntimeException(model.getName() + " Privacy Model not supported");
    }
}

