/*
 * Decompiled with CFR 0.152.
 */
package no.oslomet.aaas.utils;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.deidentifier.arx.ARXPopulationModel;
import org.deidentifier.arx.DataHandle;
import org.deidentifier.arx.risk.RiskModelPopulationUniqueness;
import org.springframework.stereotype.Component;

@Component
public class ARXPayloadAnalyser {
    private static final int PRECENT_CONVERT = 100;

    public double getPayloadLowestProsecutorRisk(DataHandle data, ARXPopulationModel pModel) {
        return data.getRiskEstimator(pModel).getSampleBasedReidentificationRisk().getLowestRisk();
    }

    public double getPayloadRecordsAffectByRisk(DataHandle data, ARXPopulationModel pModel, double risk) {
        return data.getRiskEstimator(pModel).getSampleBasedRiskDistribution().getFractionOfRecordsAtRisk(risk);
    }

    public double getPayloadAverageProsecutorRisk(DataHandle data, ARXPopulationModel pModel) {
        return data.getRiskEstimator(pModel).getSampleBasedReidentificationRisk().getAverageRisk();
    }

    public double getPayloadHighestProsecutorRisk(DataHandle data, ARXPopulationModel pModel) {
        return data.getRiskEstimator(pModel).getSampleBasedReidentificationRisk().getHighestRisk();
    }

    public double getPayloadEstimatedProsecutorRisk(DataHandle data, ARXPopulationModel pModel) {
        return data.getRiskEstimator(pModel).getSampleBasedReidentificationRisk().getEstimatedProsecutorRisk();
    }

    public double getPayloadEstimatedJournalistRisk(DataHandle data, ARXPopulationModel pModel) {
        return data.getRiskEstimator(pModel).getSampleBasedReidentificationRisk().getEstimatedJournalistRisk();
    }

    public double getPayloadEstimatedMarketerRisk(DataHandle data, ARXPopulationModel pModel) {
        return data.getRiskEstimator(pModel).getSampleBasedReidentificationRisk().getEstimatedMarketerRisk();
    }

    public double getPayloadSampleUniques(DataHandle data, ARXPopulationModel pModel) {
        return data.getRiskEstimator(pModel).getSampleBasedUniquenessRisk().getFractionOfUniqueTuples();
    }

    public double getPayloadPopulationUniques(DataHandle data, ARXPopulationModel pModel) {
        return data.getRiskEstimator(pModel).getPopulationBasedUniquenessRisk().getFractionOfUniqueTuples(this.getPayloadPopulationModel(data, pModel));
    }

    public RiskModelPopulationUniqueness.PopulationUniquenessModel getPayloadPopulationModel(DataHandle data, ARXPopulationModel pModel) {
        return data.getRiskEstimator(pModel).getPopulationBasedUniquenessRisk().getPopulationUniquenessModel();
    }

    public Set<String> getPayloadQuasiIdentifiers(DataHandle data) {
        return data.getDefinition().getQuasiIdentifyingAttributes();
    }

    public Map<String, String> getPayloadAnalysisData(DataHandle data, ARXPopulationModel pModel) {
        HashMap<String, String> metricsMap = new HashMap<String, String>();
        metricsMap.put("measure_value", "[%]");
        metricsMap.put("lowest_risk", String.valueOf(this.getPayloadLowestProsecutorRisk(data, pModel) * 100.0));
        metricsMap.put("records_affected_by_lowest_risk", String.valueOf(this.getPayloadRecordsAffectByRisk(data, pModel, this.getPayloadLowestProsecutorRisk(data, pModel)) * 100.0));
        metricsMap.put("average_prosecutor_risk", String.valueOf(this.getPayloadAverageProsecutorRisk(data, pModel) * 100.0));
        metricsMap.put("highest_prosecutor_risk", String.valueOf(this.getPayloadHighestProsecutorRisk(data, pModel) * 100.0));
        metricsMap.put("record_affected_by_highest_risk", String.valueOf(this.getPayloadRecordsAffectByRisk(data, pModel, this.getPayloadHighestProsecutorRisk(data, pModel)) * 100.0));
        metricsMap.put("estimated_prosecutor_risk", String.valueOf(this.getPayloadEstimatedProsecutorRisk(data, pModel) * 100.0));
        metricsMap.put("estimated_journalist_risk", String.valueOf(this.getPayloadEstimatedJournalistRisk(data, pModel) * 100.0));
        metricsMap.put("estimated_marketer_risk", String.valueOf(this.getPayloadEstimatedMarketerRisk(data, pModel) * 100.0));
        metricsMap.put("sample_uniques", String.valueOf(this.getPayloadSampleUniques(data, pModel) * 100.0));
        metricsMap.put("population_uniques", String.valueOf(this.getPayloadPopulationUniques(data, pModel) * 100.0));
        metricsMap.put("population_model", this.getPayloadPopulationModel(data, pModel).toString());
        metricsMap.put("quasi_identifiers", this.getPayloadQuasiIdentifiers(data).toString());
        return metricsMap;
    }
}

