/*
 * Decompiled with CFR 0.152.
 */
package no.oslomet.aaas.anonymizer;

import java.io.IOException;
import no.oslomet.aaas.anonymizer.Anonymiser;
import no.oslomet.aaas.model.AnonymizationPayload;
import no.oslomet.aaas.model.AnonymizeResult;
import no.oslomet.aaas.utils.ARXWrapper;
import org.deidentifier.arx.ARXAnonymizer;
import org.deidentifier.arx.ARXConfiguration;
import org.deidentifier.arx.ARXResult;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ARXAnonymiser
implements Anonymiser {
    private final ARXWrapper arxWrapper;

    @Autowired
    public ARXAnonymiser(ARXWrapper arxWrapper) {
        this.arxWrapper = arxWrapper;
    }

    public AnonymizeResult anonymize(AnonymizationPayload payload) {
        ARXConfiguration config = ARXConfiguration.create();
        ARXAnonymizer anonymizer = new ARXAnonymizer();
        try {
            ARXResult result = this.arxWrapper.anonymize(anonymizer, config, payload);
            String anonymisedData = this.arxWrapper.getAnonymizeData(result);
            return new AnonymizeResult(anonymisedData, result.getGlobalOptimum().getAnonymity().toString(), payload.getMetaData(), null);
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }
}

