/*
 * Decompiled with CFR 0.152.
 */
package no.oslomet.aaas.utils;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import no.oslomet.aaas.model.AnonymizationPayload;
import no.oslomet.aaas.utils.ARXConfigurationSetter;
import no.oslomet.aaas.utils.ARXModelSetter;
import org.deidentifier.arx.ARXAnonymizer;
import org.deidentifier.arx.ARXConfiguration;
import org.deidentifier.arx.ARXResult;
import org.deidentifier.arx.Data;
import org.deidentifier.arx.DataHandle;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ARXWrapper {
    private ARXConfigurationSetter arxConfigurationSetter;
    private ARXModelSetter arxModelSetter;
    private static final char CSV_SEPERATOR_CHAR = ',';

    @Autowired
    public ARXWrapper(ARXConfigurationSetter arxConfigurationSetter, ARXModelSetter arxModelSetter) {
        this.arxConfigurationSetter = arxConfigurationSetter;
        this.arxModelSetter = arxModelSetter;
    }

    public Data setData(String rawdata) {
        Data data = null;
        try {
            ByteArrayInputStream stream = new ByteArrayInputStream(rawdata.getBytes(StandardCharsets.UTF_8));
            data = Data.create((InputStream)stream, (Charset)Charset.defaultCharset(), (char)',');
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return data;
    }

    public ARXAnonymizer setAnonymizer(ARXAnonymizer anonymizer) {
        anonymizer.setMaximumSnapshotSizeDataset(0.2);
        anonymizer.setMaximumSnapshotSizeSnapshot(0.2);
        anonymizer.setHistorySize(200);
        return anonymizer;
    }

    public ARXResult anonymize(ARXAnonymizer anonymizer, ARXConfiguration config, AnonymizationPayload payload) throws IOException {
        Data data = this.setData(payload.getData());
        data = this.arxModelSetter.setAttributeTypes(data, payload);
        data = this.arxModelSetter.setHierarchies(data, payload);
        config = this.arxConfigurationSetter.setSuppressionLimit(config);
        config = this.arxConfigurationSetter.setPrivacyModels(config, payload);
        anonymizer = this.setAnonymizer(anonymizer);
        return anonymizer.anonymize(data, config);
    }

    public String getAnonymizeData(ARXResult result) throws IOException {
        DataHandle handle = result.getOutput();
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        handle.save((OutputStream)outputStream, ',');
        return new String(outputStream.toByteArray());
    }
}

