/*
 * Decompiled with CFR 0.152.
 */
package no.oslomet.aaas.anonymizer;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import no.oslomet.aaas.anonymizer.Anonymiser;
import no.oslomet.aaas.exception.UnableToAnonymizeDataException;
import no.oslomet.aaas.model.AnonymizationPayload;
import no.oslomet.aaas.model.AnonymizeResult;
import no.oslomet.aaas.utils.ConfigurationFactory;
import no.oslomet.aaas.utils.DataFactory;
import org.deidentifier.arx.ARXAnonymizer;
import org.deidentifier.arx.ARXConfiguration;
import org.deidentifier.arx.ARXResult;
import org.deidentifier.arx.Data;
import org.deidentifier.arx.DataHandle;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ARXAnonymiser
implements Anonymiser {
    private final DataFactory dataFactory;
    private final ConfigurationFactory configFactory;

    @Autowired
    public ARXAnonymiser(DataFactory dataFactory, ConfigurationFactory configFactory) {
        this.dataFactory = dataFactory;
        this.configFactory = configFactory;
    }

    public AnonymizeResult anonymize(AnonymizationPayload payload) {
        ARXAnonymizer anonymizer = new ARXAnonymizer();
        this.configureAnonymizer(anonymizer);
        Data data = this.dataFactory.create(payload);
        ARXConfiguration config = this.configFactory.create(payload.getMetaData());
        try {
            ARXResult result = anonymizer.anonymize(data, config);
            List anonymisedData = this.createRawDataList(result);
            return new AnonymizeResult(anonymisedData, result.getGlobalOptimum().getAnonymity().toString(), payload.getMetaData(), null);
        }
        catch (IOException e) {
            throw new UnableToAnonymizeDataException(e.getMessage());
        }
    }

    private void configureAnonymizer(ARXAnonymizer anonymizer) {
        anonymizer.setMaximumSnapshotSizeDataset(0.2);
        anonymizer.setMaximumSnapshotSizeSnapshot(0.2);
        anonymizer.setHistorySize(200);
    }

    private List<String[]> createRawDataList(ARXResult result) {
        DataHandle handle = result.getOutput();
        ArrayList<String[]> resultData = new ArrayList<String[]>();
        handle.iterator().forEachRemaining(resultData::add);
        return resultData;
    }
}

