/*
 * Decompiled with CFR 0.152.
 */
package no.oslomet.aaas.utils;

import java.util.Map;
import no.oslomet.aaas.model.MetaData;
import no.oslomet.aaas.model.PrivacyModel;
import no.oslomet.aaas.utils.ARXPrivacyCriterionFactory;
import no.oslomet.aaas.utils.ConfigurationFactory;
import org.deidentifier.arx.ARXConfiguration;
import org.deidentifier.arx.criteria.PrivacyCriterion;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ARXConfigurationFactory
implements ConfigurationFactory {
    private ARXPrivacyCriterionFactory arxPrivacyCriterionFactory;

    @Autowired
    public ARXConfigurationFactory(ARXPrivacyCriterionFactory arxPrivacyCriterionFactory) {
        this.arxPrivacyCriterionFactory = arxPrivacyCriterionFactory;
    }

    public ARXConfiguration create(MetaData metaData) {
        ARXConfiguration config = ARXConfiguration.create();
        this.setSuppressionLimit(config);
        this.setPrivacyModels(config, metaData);
        return config;
    }

    private void setSuppressionLimit(ARXConfiguration config) {
        config.setSuppressionLimit(0.02);
    }

    private void setPrivacyModels(ARXConfiguration config, MetaData metaData) {
        for (Map.Entry entry : metaData.getModels().entrySet()) {
            config.addPrivacyModel(this.getPrivacyModel((PrivacyModel)entry.getKey(), (Map)entry.getValue()));
        }
    }

    private PrivacyCriterion getPrivacyModel(PrivacyModel model, Map<String, String> params) {
        return this.arxPrivacyCriterionFactory.create(model, params);
    }
}

