/*
 * Decompiled with CFR 0.152.
 */
package no.oslomet.aaas.utils;

import java.util.List;
import java.util.Map;
import no.oslomet.aaas.model.AnalysationPayload;
import no.oslomet.aaas.model.AnonymizationPayload;
import no.oslomet.aaas.model.AttributeTypeModel;
import no.oslomet.aaas.model.MetaData;
import no.oslomet.aaas.utils.DataFactory;
import org.deidentifier.arx.AttributeType;
import org.deidentifier.arx.Data;
import org.springframework.stereotype.Component;

@Component
public class ARXDataFactory
implements DataFactory {
    public Data create(AnonymizationPayload payload) {
        this.validateParameters(payload.getData(), payload.getMetaData());
        Data data = this.createData(payload.getData());
        this.setAttributeTypes(data, payload.getMetaData().getAttributeTypeList());
        this.setHierarchies(data, payload.getMetaData());
        return data;
    }

    public Data create(AnalysationPayload payload) {
        this.validateParameters(payload.getData(), payload.getAttributeTypes());
        Data data = this.createData(payload.getData());
        this.setAttributeTypes(data, payload.getAttributeTypes());
        return data;
    }

    private void validateParameters(List<String[]> rawData, MetaData metaData) {
        if (rawData == null) {
            throw new IllegalArgumentException("rawData parameter is null");
        }
        if (metaData == null) {
            throw new IllegalArgumentException("metaData parameter is null");
        }
    }

    private void validateParameters(List<String[]> rawData, Map<String, AttributeTypeModel> attributeTypes) {
        if (rawData == null) {
            throw new IllegalArgumentException("rawData parameter is null");
        }
        if (attributeTypes == null) {
            throw new IllegalArgumentException("Attribute types parameter is null");
        }
    }

    private Data createData(List<String[]> rawData) {
        return Data.create(rawData);
    }

    private void setAttributeTypes(Data data, Map<String, AttributeTypeModel> attributeTypes) {
        for (Map.Entry<String, AttributeTypeModel> entry : attributeTypes.entrySet()) {
            data.getDefinition().setAttributeType(entry.getKey(), entry.getValue().getAttributeType());
        }
    }

    private void setHierarchies(Data data, MetaData metaData) {
        for (Map.Entry entry : metaData.getHierarchy().entrySet()) {
            AttributeType.Hierarchy hierarchy = AttributeType.Hierarchy.create((String[][])((String[][])entry.getValue()));
            data.getDefinition().setAttributeType((String)entry.getKey(), (AttributeType)hierarchy);
        }
    }
}

