/*
 * Decompiled with CFR 0.152.
 */
package no.oslomet.aaas.controller;

import javax.servlet.http.HttpServletRequest;
import javax.validation.Valid;
import no.oslomet.aaas.model.AnonymizationResultPayload;
import no.oslomet.aaas.model.Request;
import no.oslomet.aaas.service.AnonymizationService;
import no.oslomet.aaas.service.LoggerService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@CrossOrigin
@RestController
@RequestMapping(value={"/api/anonymize"})
public class AnonymizationController {
    private final AnonymizationService anonymizationService;
    private final LoggerService loggerService;

    @Autowired
    AnonymizationController(AnonymizationService anonymizationService, LoggerService loggerService) {
        this.anonymizationService = anonymizationService;
        this.loggerService = loggerService;
    }

    @PostMapping
    public AnonymizationResultPayload anonymization(@Valid @RequestBody Request payload, HttpServletRequest request) {
        this.loggerService.loggPayload(payload, request.getRemoteAddr(), AnonymizationController.class);
        return this.anonymizationService.anonymize(payload);
    }
}

