/*
 * Decompiled with CFR 0.152.
 */
package no.oslomet.aaas.controller;

import java.util.Date;
import no.oslomet.aaas.exception.ExceptionResponse;
import no.oslomet.aaas.exception.UnableToAnonymizeDataException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.HttpRequestMethodNotSupportedException;
import org.springframework.web.bind.MethodArgumentNotValidException;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.context.request.WebRequest;

@ControllerAdvice
class GlobalControllerExceptionHandler {
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    GlobalControllerExceptionHandler() {
    }

    @ExceptionHandler(value={Exception.class})
    public final ResponseEntity<Object> handleExceptionAllExceptions(Exception ex, WebRequest request) {
        String error = "Exception.class error, HttpStatus: INTERNAL_SERVER_ERROR, ExceptionToString: " + ex.toString();
        this.logger.error(error);
        ExceptionResponse exceptionResponse = new ExceptionResponse(new Date(), ex.getMessage(), request.getDescription(false));
        return new ResponseEntity((Object)exceptionResponse, HttpStatus.INTERNAL_SERVER_ERROR);
    }

    @ExceptionHandler(value={NullPointerException.class})
    public final ResponseEntity<Object> handleNullPointerExceptions(Exception ex, WebRequest request) {
        ExceptionResponse exceptionResponse = new ExceptionResponse(new Date(), ex.toString(), request.getDescription(false));
        return new ResponseEntity((Object)exceptionResponse, HttpStatus.INTERNAL_SERVER_ERROR);
    }

    @ExceptionHandler(value={HttpRequestMethodNotSupportedException.class})
    public final ResponseEntity<Object> handleMethodNotSupportedExceptions(Exception ex, WebRequest request) {
        String error = "Exception error:Exception thrown when a request handler does not support a specific request method. HttpStatus: METHOD_NOT_ALLOWED, ExceptionToString: " + ex.toString();
        this.logger.error(error);
        ExceptionResponse exceptionResponse = new ExceptionResponse(new Date(), ex.getMessage(), request.getDescription(false));
        return new ResponseEntity((Object)exceptionResponse, HttpStatus.METHOD_NOT_ALLOWED);
    }

    @ExceptionHandler(value={IllegalArgumentException.class})
    public ResponseEntity handleIllegalArgumentExceptions(IllegalArgumentException ex, WebRequest request) {
        String error = "Exception error:Thrown to indicate that a method has been passed an illegal or inappropriate argument. HttpStatus: BAD_REQUEST, ExceptionToString: " + ex.toString();
        this.logger.error(error);
        ExceptionResponse exceptionResponse = new ExceptionResponse(new Date(), ex.getMessage(), request.getDescription(false));
        return new ResponseEntity((Object)exceptionResponse, HttpStatus.BAD_REQUEST);
    }

    @ExceptionHandler(value={MethodArgumentNotValidException.class})
    public ResponseEntity handleMethodArgumentNotValidException(MethodArgumentNotValidException ex, WebRequest request) {
        String error = "Exception error:Exception to be thrown when validation on an argument annotated with @Valid fails. HttpStatus: BAD_REQUEST, ExceptionToString: " + ex.toString();
        this.logger.error(error);
        ExceptionResponse exceptionResponse = new ExceptionResponse(new Date(), ex.getMessage(), request.getDescription(false));
        return new ResponseEntity((Object)exceptionResponse, HttpStatus.BAD_REQUEST);
    }

    @ExceptionHandler(value={UnableToAnonymizeDataException.class})
    public ResponseEntity<Object> handleUnableToAnonymizeDataException(UnableToAnonymizeDataException ex, WebRequest request) {
        ExceptionResponse exceptionResponse = new ExceptionResponse(new Date(), "Unable to anonymize the dataset with the provided attributes and hierarchies. A common cause of this error is more thant one QUASIIDENTIFYING attribute without a hierarchy", request.getDescription(false));
        return new ResponseEntity((Object)exceptionResponse, HttpStatus.BAD_REQUEST);
    }
}

