/*
 * Decompiled with CFR 0.152.
 */
package no.oslomet.aaas.analyzer;

import no.oslomet.aaas.analyzer.ARXReIdentificationRiskFactory;
import no.oslomet.aaas.analyzer.Analyzer;
import no.oslomet.aaas.model.Request;
import no.oslomet.aaas.model.analytics.DistributionOfRisk;
import no.oslomet.aaas.model.analytics.ReIdentificationRisk;
import no.oslomet.aaas.model.analytics.RiskProfile;
import no.oslomet.aaas.utils.DataFactory;
import org.deidentifier.arx.ARXPopulationModel;
import org.deidentifier.arx.Data;
import org.deidentifier.arx.DataHandle;
import org.deidentifier.arx.risk.RiskEstimateBuilder;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ARXAnalyzer
implements Analyzer {
    private final DataFactory dataFactory;

    @Autowired
    public ARXAnalyzer(DataFactory dataFactory) {
        this.dataFactory = dataFactory;
    }

    public RiskProfile analyze(Request payload) {
        Data data = this.dataFactory.create(payload);
        DataHandle dataToAnalyse = data.getHandle();
        ARXPopulationModel pModel = ARXPopulationModel.create((int)data.getHandle().getNumRows(), (double)0.01);
        return new RiskProfile(this.reIdentificationRisk(dataToAnalyse, pModel), this.distributionOfRisk(dataToAnalyse, pModel));
    }

    private DistributionOfRisk distributionOfRisk(DataHandle dataToAnalyse, ARXPopulationModel pModel) {
        return DistributionOfRisk.create((RiskEstimateBuilder)dataToAnalyse.getRiskEstimator(pModel));
    }

    private ReIdentificationRisk reIdentificationRisk(DataHandle dataToAnalyse, ARXPopulationModel pModel) {
        return ARXReIdentificationRiskFactory.create((DataHandle)dataToAnalyse, (ARXPopulationModel)pModel);
    }
}

