/*
 * Decompiled with CFR 0.152.
 */
package no.oslomet.aaas.anonymizer;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import no.oslomet.aaas.anonymizer.Anonymizer;
import no.oslomet.aaas.exception.UnableToAnonymizeDataException;
import no.oslomet.aaas.exception.UnableToAnonymizeDataInvalidDataSetException;
import no.oslomet.aaas.model.AnonymizationMetrics;
import no.oslomet.aaas.model.AnonymizeResult;
import no.oslomet.aaas.model.Request;
import no.oslomet.aaas.utils.ConfigurationFactory;
import no.oslomet.aaas.utils.DataFactory;
import org.deidentifier.arx.ARXConfiguration;
import org.deidentifier.arx.ARXResult;
import org.deidentifier.arx.Data;
import org.deidentifier.arx.DataHandle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ARXAnonymizer
implements Anonymizer {
    private final DataFactory dataFactory;
    private final ConfigurationFactory configFactory;
    private final Logger logger;

    @Autowired
    public ARXAnonymizer(DataFactory dataFactory, ConfigurationFactory configFactory) {
        this.dataFactory = dataFactory;
        this.configFactory = configFactory;
        this.logger = LoggerFactory.getLogger(this.getClass());
    }

    public AnonymizeResult anonymize(Request payload) {
        org.deidentifier.arx.ARXAnonymizer anonymizer = new org.deidentifier.arx.ARXAnonymizer();
        this.configureAnonymizer(anonymizer);
        Data data = this.dataFactory.create(payload);
        try {
            ARXConfiguration config = this.configFactory.create(payload.getPrivacyModels());
            ARXResult result = anonymizer.anonymize(data, config);
            return this.packageResult(result, payload);
        }
        catch (IOException | NullPointerException e) {
            this.logger.error(String.format("Exception error: %s", e.toString()));
            throw new UnableToAnonymizeDataException(e.toString());
        }
        catch (IndexOutOfBoundsException e) {
            String errorMessage = String.format("%s, Failed to create dataset. Check if dataset format and attribute dataset fields are correct", e.toString());
            this.logger.error(String.format("Exception error: %s", errorMessage));
            throw new UnableToAnonymizeDataInvalidDataSetException(errorMessage);
        }
    }

    private AnonymizeResult packageResult(ARXResult result, Request payload) {
        List anonymisedData = this.createRawDataList(result);
        AnonymizationMetrics attributeGeneralizationLevels = new AnonymizationMetrics(result);
        return new AnonymizeResult(anonymisedData, result.getGlobalOptimum().getAnonymity().toString(), attributeGeneralizationLevels, payload.getAttributes());
    }

    private void configureAnonymizer(org.deidentifier.arx.ARXAnonymizer anonymizer) {
        anonymizer.setMaximumSnapshotSizeDataset(0.2);
        anonymizer.setMaximumSnapshotSizeSnapshot(0.2);
        anonymizer.setHistorySize(200);
    }

    private List<String[]> createRawDataList(ARXResult result) {
        DataHandle handle = result.getOutput();
        ArrayList<String[]> resultData = new ArrayList<String[]>();
        handle.iterator().forEachRemaining(resultData::add);
        return resultData;
    }
}

