/*
 * Decompiled with CFR 0.152.
 */
package no.oslomet.aaas.utils;

import java.util.List;
import java.util.Map;
import no.oslomet.aaas.model.PrivacyCriterionModel;
import no.oslomet.aaas.utils.ARXPrivacyCriterionFactory;
import no.oslomet.aaas.utils.ConfigurationFactory;
import org.deidentifier.arx.ARXConfiguration;
import org.deidentifier.arx.criteria.PrivacyCriterion;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ARXConfigurationFactory
implements ConfigurationFactory {
    private ARXPrivacyCriterionFactory arxPrivacyCriterionFactory;

    @Autowired
    public ARXConfigurationFactory(ARXPrivacyCriterionFactory arxPrivacyCriterionFactory) {
        this.arxPrivacyCriterionFactory = arxPrivacyCriterionFactory;
    }

    public ARXConfiguration create(List<PrivacyCriterionModel> privacyModels) {
        ARXConfiguration config = ARXConfiguration.create();
        this.setSuppressionLimit(config);
        this.setPrivacyModels(config, privacyModels);
        return config;
    }

    private void setSuppressionLimit(ARXConfiguration config) {
        config.setSuppressionLimit(0.02);
    }

    private void setPrivacyModels(ARXConfiguration config, List<PrivacyCriterionModel> privacyModels) {
        for (PrivacyCriterionModel model : privacyModels) {
            config.addPrivacyModel(this.getPrivacyModel(model.getPrivacyModel(), model.getParams()));
        }
    }

    private PrivacyCriterion getPrivacyModel(PrivacyCriterionModel.PrivacyModel model, Map<String, String> params) {
        return this.arxPrivacyCriterionFactory.create(model, params);
    }
}

