/*
 * Decompiled with CFR 0.152.
 */
package no.oslomet.aaas.utils;

import java.util.Map;
import no.oslomet.aaas.exception.AaaSRuntimeException;
import no.oslomet.aaas.model.PrivacyCriterionModel;
import no.oslomet.aaas.utils.ARXPrivacyCriterionFactory;
import org.deidentifier.arx.criteria.DistinctLDiversity;
import org.deidentifier.arx.criteria.EntropyLDiversity;
import org.deidentifier.arx.criteria.EqualDistanceTCloseness;
import org.deidentifier.arx.criteria.KAnonymity;
import org.deidentifier.arx.criteria.OrderedDistanceTCloseness;
import org.deidentifier.arx.criteria.PrivacyCriterion;
import org.deidentifier.arx.criteria.RecursiveCLDiversity;
import org.springframework.stereotype.Component;

@Component
public class ARXPrivacyCriterionFactory {
    private static final String COLUMNNAME = "column_name";

    PrivacyCriterion create(PrivacyCriterionModel.PrivacyModel model, Map<String, String> params) {
        switch (1.$SwitchMap$no$oslomet$aaas$model$PrivacyCriterionModel$PrivacyModel[model.ordinal()]) {
            case 1: {
                return new KAnonymity(Integer.parseInt(params.get("k")));
            }
            case 2: {
                return new DistinctLDiversity(params.get(COLUMNNAME), Integer.parseInt(params.get("l")));
            }
            case 3: {
                return new EntropyLDiversity(params.get(COLUMNNAME), (double)Integer.parseInt(params.get("l")), EntropyLDiversity.EntropyEstimator.SHANNON);
            }
            case 4: {
                return new EntropyLDiversity(params.get(COLUMNNAME), (double)Integer.parseInt(params.get("l")), EntropyLDiversity.EntropyEstimator.GRASSBERGER);
            }
            case 5: {
                return new RecursiveCLDiversity(params.get(COLUMNNAME), (double)Integer.parseInt(params.get("l")), Integer.parseInt(params.get("c")));
            }
            case 6: {
                return new OrderedDistanceTCloseness(params.get(COLUMNNAME), Double.parseDouble(params.get("t")));
            }
            case 7: {
                return new EqualDistanceTCloseness(params.get(COLUMNNAME), Double.parseDouble(params.get("t")));
            }
        }
        throw new AaaSRuntimeException(model.getName() + " Privacy Model not supported");
    }
}

