/*
 * Decompiled with CFR 0.152.
 */
package no.oslomet.aaas.analyzer;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import no.oslomet.aaas.model.analytics.ReIdentificationRisk;
import org.deidentifier.arx.ARXPopulationModel;
import org.deidentifier.arx.DataHandle;
import org.deidentifier.arx.risk.RiskEstimateBuilder;
import org.deidentifier.arx.risk.RiskModelPopulationUniqueness;
import org.deidentifier.arx.risk.RiskModelSampleRiskDistribution;
import org.deidentifier.arx.risk.RiskModelSampleRisks;
import org.deidentifier.arx.risk.RiskModelSampleSummary;
import org.deidentifier.arx.risk.RiskModelSampleUniqueness;
import org.springframework.stereotype.Component;

/*
 * Exception performing whole class analysis ignored.
 */
@Component
public class ARXReIdentificationRiskFactory {
    private static final int PRECENT_CONVERT = 100;
    private static final double THRESHOLD = 0.5;

    private ARXReIdentificationRiskFactory() {
    }

    public static ReIdentificationRisk create(DataHandle data, ARXPopulationModel pModel) {
        Map measures = ARXReIdentificationRiskFactory.reIdentificationRisk((DataHandle)data, (ARXPopulationModel)pModel);
        return new ReIdentificationRisk(measures);
    }

    private static Map<String, String> reIdentificationRisk(DataHandle data, ARXPopulationModel pModel) {
        RiskEstimateBuilder riskEstimateBuilder = data.getRiskEstimator(pModel);
        RiskModelSampleRisks sampleRisks = riskEstimateBuilder.getSampleBasedReidentificationRisk();
        RiskModelSampleRiskDistribution sampleRiskDistribution = riskEstimateBuilder.getSampleBasedRiskDistribution();
        RiskModelSampleSummary riskModelSampleSummary = data.getRiskEstimator(pModel).getSampleBasedRiskSummary(0.5);
        RiskModelPopulationUniqueness populationBasedUniquenessRisk = riskEstimateBuilder.getPopulationBasedUniquenessRisk();
        double lowestRisk = ARXReIdentificationRiskFactory.lowestProsecutorRisk((RiskModelSampleRisks)sampleRisks);
        double highestRisk = ARXReIdentificationRiskFactory.highestProsecutorRisk((RiskModelSampleRisks)sampleRisks);
        double highestJournalistRisk = ARXReIdentificationRiskFactory.highestJournalistRisk((RiskModelSampleSummary)riskModelSampleSummary);
        HashMap<String, String> metricsMap = new HashMap<String, String>();
        metricsMap.put("lowest_risk", String.valueOf(lowestRisk * 100.0));
        metricsMap.put("records_affected_by_lowest_risk", String.valueOf(ARXReIdentificationRiskFactory.recordsAffectByRisk((RiskModelSampleRiskDistribution)sampleRiskDistribution, (double)lowestRisk) * 100.0));
        metricsMap.put("average_prosecutor_risk", String.valueOf(ARXReIdentificationRiskFactory.averageProsecutorRisk((RiskModelSampleRisks)sampleRisks) * 100.0));
        metricsMap.put("highest_prosecutor_risk", String.valueOf(highestRisk * 100.0));
        metricsMap.put("records_affected_by_highest_prosecutor_risk", String.valueOf(ARXReIdentificationRiskFactory.recordsAffectByRisk((RiskModelSampleRiskDistribution)sampleRiskDistribution, (double)highestRisk) * 100.0));
        metricsMap.put("Prosecutor_attacker_success_rate", String.valueOf(ARXReIdentificationRiskFactory.prosecutorAttackSuccessRate((RiskModelSampleSummary)riskModelSampleSummary) * 100.0));
        metricsMap.put("highest_journalist_risk", String.valueOf(ARXReIdentificationRiskFactory.highestJournalistRisk((RiskModelSampleSummary)riskModelSampleSummary) * 100.0));
        metricsMap.put("records_affected_by_highest_journalist_risk", String.valueOf(ARXReIdentificationRiskFactory.recordsAffectByRisk((RiskModelSampleRiskDistribution)sampleRiskDistribution, (double)highestJournalistRisk) * 100.0));
        metricsMap.put("Journalist_attacker_success_rate", String.valueOf(ARXReIdentificationRiskFactory.journalistAttackerSuccessRate((RiskModelSampleSummary)riskModelSampleSummary) * 100.0));
        metricsMap.put("Marketer_attacker_success_rate", String.valueOf(ARXReIdentificationRiskFactory.marketerAttackerSuccessRate((RiskModelSampleSummary)riskModelSampleSummary) * 100.0));
        metricsMap.put("estimated_prosecutor_risk", String.valueOf(ARXReIdentificationRiskFactory.estimatedProsecutorRisk((RiskModelSampleRisks)sampleRisks) * 100.0));
        metricsMap.put("estimated_journalist_risk", String.valueOf(ARXReIdentificationRiskFactory.estimatedJournalistRisk((RiskModelSampleRisks)sampleRisks) * 100.0));
        metricsMap.put("estimated_marketer_risk", String.valueOf(ARXReIdentificationRiskFactory.estimatedMarketerRisk((RiskModelSampleRisks)sampleRisks) * 100.0));
        metricsMap.put("sample_uniques", String.valueOf(ARXReIdentificationRiskFactory.sampleUniques((RiskModelSampleUniqueness)riskEstimateBuilder.getSampleBasedUniquenessRisk()) * 100.0));
        metricsMap.put("population_uniques", String.valueOf(ARXReIdentificationRiskFactory.populationUniques((RiskModelPopulationUniqueness)populationBasedUniquenessRisk) * 100.0));
        metricsMap.put("population_model", ARXReIdentificationRiskFactory.populationUniquenessModel((RiskModelPopulationUniqueness)populationBasedUniquenessRisk).toString());
        metricsMap.put("quasi_identifiers", ARXReIdentificationRiskFactory.quasiIdentifiers((DataHandle)data).toString());
        return metricsMap;
    }

    private static double lowestProsecutorRisk(RiskModelSampleRisks riskModelSampleRisks) {
        return riskModelSampleRisks.getLowestRisk();
    }

    private static double recordsAffectByRisk(RiskModelSampleRiskDistribution sampleRiskDistribution, double risk) {
        return sampleRiskDistribution.getFractionOfRecordsAtRisk(risk);
    }

    private static double averageProsecutorRisk(RiskModelSampleRisks riskModelSampleRisks) {
        return riskModelSampleRisks.getAverageRisk();
    }

    private static double highestProsecutorRisk(RiskModelSampleRisks riskModelSampleRisks) {
        return riskModelSampleRisks.getHighestRisk();
    }

    private static double highestJournalistRisk(RiskModelSampleSummary riskModelSampleSummary) {
        return riskModelSampleSummary.getJournalistRisk().getHighestRisk();
    }

    private static double estimatedProsecutorRisk(RiskModelSampleRisks riskModelSampleRisks) {
        return riskModelSampleRisks.getEstimatedProsecutorRisk();
    }

    private static double estimatedJournalistRisk(RiskModelSampleRisks riskModelSampleRisks) {
        return riskModelSampleRisks.getEstimatedJournalistRisk();
    }

    private static double estimatedMarketerRisk(RiskModelSampleRisks riskModelSampleRisks) {
        return riskModelSampleRisks.getEstimatedMarketerRisk();
    }

    private static double sampleUniques(RiskModelSampleUniqueness riskModelSampleUniqueness) {
        return riskModelSampleUniqueness.getFractionOfUniqueTuples();
    }

    private static double populationUniques(RiskModelPopulationUniqueness riskModelPopulationUniqueness) {
        return riskModelPopulationUniqueness.getFractionOfUniqueTuples(ARXReIdentificationRiskFactory.populationUniquenessModel((RiskModelPopulationUniqueness)riskModelPopulationUniqueness));
    }

    private static RiskModelPopulationUniqueness.PopulationUniquenessModel populationUniquenessModel(RiskModelPopulationUniqueness riskModelPopulationUniqueness) {
        return riskModelPopulationUniqueness.getPopulationUniquenessModel();
    }

    private static Set<String> quasiIdentifiers(DataHandle data) {
        return data.getDefinition().getQuasiIdentifyingAttributes();
    }

    private static double prosecutorAttackSuccessRate(RiskModelSampleSummary riskModelSampleSummary) {
        return riskModelSampleSummary.getProsecutorRisk().getSuccessRate();
    }

    private static double journalistAttackerSuccessRate(RiskModelSampleSummary riskModelSampleSummary) {
        return riskModelSampleSummary.getJournalistRisk().getSuccessRate();
    }

    private static double marketerAttackerSuccessRate(RiskModelSampleSummary riskModelSampleSummary) {
        return riskModelSampleSummary.getMarketerRisk().getSuccessRate();
    }
}

