/*
 * Decompiled with CFR 0.152.
 */
package no.oslomet.aaas.controller;

import javax.servlet.http.HttpServletRequest;
import javax.validation.Valid;
import no.oslomet.aaas.model.Request;
import no.oslomet.aaas.model.analytics.RiskProfile;
import no.oslomet.aaas.service.AnalyzationService;
import no.oslomet.aaas.service.LoggerService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@CrossOrigin
@RestController
@RequestMapping(value={"/api/analyze"})
public class AnalyzationController {
    private final AnalyzationService analyzationService;
    private final LoggerService loggerService;

    @Autowired
    AnalyzationController(AnalyzationService analyzationService, LoggerService loggerService) {
        this.analyzationService = analyzationService;
        this.loggerService = loggerService;
    }

    @PostMapping
    public RiskProfile getPayloadAnalyze(@Valid @RequestBody Request payload, HttpServletRequest request) {
        long requestRecivedTime = System.currentTimeMillis();
        this.loggerService.loggPayload(payload, request.getRemoteAddr(), AnalyzationController.class);
        RiskProfile analyzationResult = this.analyzationService.analyze(payload);
        long requestProcessingTime = System.currentTimeMillis() - requestRecivedTime;
        this.loggerService.loggAnalyzationResult(analyzationResult, payload, request.getRemoteAddr(), requestProcessingTime, AnalyzationController.class);
        return analyzationResult;
    }
}

