/*
 * Decompiled with CFR 0.152.
 */
package no.oslomet.aaas.controller;

import javax.servlet.http.HttpServletRequest;
import no.oslomet.aaas.model.hierarchy.Hierarchy;
import no.oslomet.aaas.model.hierarchy.HierarchyRequest;
import no.oslomet.aaas.service.HierarchyService;
import no.oslomet.aaas.service.LoggerService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@CrossOrigin
@RestController
@RequestMapping(value={"/api/hierarchy"})
public class HierarchyController {
    private final LoggerService loggerService;
    private final HierarchyService hierarchyService;

    @Autowired
    HierarchyController(HierarchyService hierarchyService, LoggerService loggerService) {
        this.hierarchyService = hierarchyService;
        this.loggerService = loggerService;
    }

    @PostMapping
    public Hierarchy hierarchy(@RequestBody HierarchyRequest hierarchyRequest, HttpServletRequest request) {
        Logger logger = LoggerFactory.getLogger(this.getClass());
        logger.info("Hierarchy request: " + hierarchyRequest.getBuilder().toString());
        return this.hierarchyService.hierarchy(hierarchyRequest);
    }
}

