/*
 * Decompiled with CFR 0.152.
 */
package no.oslomet.aaas.model.hierarchy.interval;

import com.fasterxml.jackson.annotation.JsonCreator;
import java.util.List;
import no.oslomet.aaas.model.hierarchy.Hierarchy;
import no.oslomet.aaas.model.hierarchy.HierarchyBuilder;
import no.oslomet.aaas.model.hierarchy.Level;
import no.oslomet.aaas.model.hierarchy.interval.Interval;
import no.oslomet.aaas.model.hierarchy.interval.Range;
import org.deidentifier.arx.DataType;
import org.deidentifier.arx.aggregates.HierarchyBuilderGroupingBased;
import org.deidentifier.arx.aggregates.HierarchyBuilderIntervalBased;

public class IntervalBasedHierarchyBuilder
implements HierarchyBuilder {
    private final List<Interval> intervals;
    private final List<Level> levels;
    private Range lowerRange;
    private Range upperRange;

    @JsonCreator
    public IntervalBasedHierarchyBuilder(List<Interval> intervals, List<Level> levels, Range lowerRange, Range upperRange) {
        this.intervals = intervals;
        this.levels = levels;
        this.lowerRange = lowerRange;
        this.upperRange = upperRange;
    }

    public Hierarchy build(String[] column) {
        HierarchyBuilderIntervalBased builder = this.arxHierarchyBuilderIntervalBased();
        builder.setAggregateFunction(DataType.INTEGER.createAggregate().createIntervalFunction(true, false));
        this.applyIntervals(builder);
        this.applyLevels(builder);
        builder.prepare(column);
        return new Hierarchy(builder.build().getHierarchy());
    }

    private HierarchyBuilderIntervalBased<Long> arxHierarchyBuilderIntervalBased() {
        if (this.upperRange == null || this.lowerRange == null) {
            return HierarchyBuilderIntervalBased.create((DataType)DataType.INTEGER);
        }
        return HierarchyBuilderIntervalBased.create((DataType)DataType.INTEGER, (HierarchyBuilderIntervalBased.Range)this.lowerRange.arxRange(), (HierarchyBuilderIntervalBased.Range)this.upperRange.arxRange());
    }

    private void applyIntervals(HierarchyBuilderIntervalBased<Long> builder) {
        if (this.intervals != null) {
            for (Interval interval : this.intervals) {
                interval.applyTo(builder);
            }
        }
    }

    private void applyLevels(HierarchyBuilderIntervalBased builder) {
        if (this.levels != null) {
            for (Level level : this.levels) {
                level.applyTo((HierarchyBuilderGroupingBased)builder);
            }
        }
    }

    public List<Interval> getIntervals() {
        return this.intervals;
    }

    public List<Level> getLevels() {
        return this.levels;
    }

    public Range getLowerRange() {
        return this.lowerRange;
    }

    public Range getUpperRange() {
        return this.upperRange;
    }
}

