/*
 * Decompiled with CFR 0.152.
 */
package no.oslomet.aaas.model.hierarchy.interval;

import com.fasterxml.jackson.annotation.JsonCreator;
import org.deidentifier.arx.aggregates.HierarchyBuilderIntervalBased;

public class Interval {
    private final Number from;
    private final Number to;
    private final String label;

    @JsonCreator
    public Interval(Number from, Number to, String label) {
        this.from = from;
        this.to = to;
        this.label = label;
    }

    Interval(Number from, Number to) {
        this.from = from;
        this.to = to;
        this.label = null;
    }

    public Number getFrom() {
        return this.from;
    }

    public Number getTo() {
        return this.to;
    }

    public String getLabel() {
        return this.label;
    }

    void applyTo(HierarchyBuilderIntervalBased<Long> builder) {
        if (this.getLabel() == null) {
            builder.addInterval((Object)this.getFrom().longValue(), (Object)this.getTo().longValue());
        } else {
            builder.addInterval((Object)this.getFrom().longValue(), (Object)this.getTo().longValue(), this.getLabel());
        }
    }

    void applyToDouble(HierarchyBuilderIntervalBased<Double> builder) {
        if (this.getLabel() == null) {
            builder.addInterval((Object)this.getFrom().doubleValue(), (Object)this.getTo().doubleValue());
        } else {
            builder.addInterval((Object)this.getFrom().doubleValue(), (Object)this.getTo().doubleValue(), this.getLabel());
        }
    }

    public String toString() {
        return "Interval{from=" + this.from + ", to=" + this.to + ", label='" + this.label + "'}";
    }
}

