/*
 * Decompiled with CFR 0.152.
 */
package no.oslomet.aaas.model.hierarchy.interval;

import com.fasterxml.jackson.annotation.JsonCreator;
import java.util.List;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import no.oslomet.aaas.model.hierarchy.Hierarchy;
import no.oslomet.aaas.model.hierarchy.HierarchyBuilder;
import no.oslomet.aaas.model.hierarchy.Level;
import no.oslomet.aaas.model.hierarchy.interval.Interval;
import no.oslomet.aaas.model.hierarchy.interval.IntervalBasedHierarchyBuilder;
import no.oslomet.aaas.model.hierarchy.interval.Range;
import org.deidentifier.arx.DataType;
import org.deidentifier.arx.aggregates.HierarchyBuilderGroupingBased;
import org.deidentifier.arx.aggregates.HierarchyBuilderIntervalBased;

public class IntervalBasedHierarchyBuilder
implements HierarchyBuilder {
    @NotNull
    private final List<Interval> intervals;
    @NotNull
    @Valid
    private final List<Level> levels;
    private Range lowerRange;
    private Range upperRange;
    @NotNull
    private final BuilderDataType dataType;

    @JsonCreator
    public IntervalBasedHierarchyBuilder(List<Interval> intervals, List<Level> levels, Range lowerRange, Range upperRange, BuilderDataType dataType) {
        this.intervals = intervals;
        this.levels = levels;
        this.lowerRange = lowerRange;
        this.upperRange = upperRange;
        this.dataType = dataType;
    }

    public Hierarchy build(String[] column) {
        if (this.dataType == BuilderDataType.LONG) {
            HierarchyBuilderIntervalBased builder = this.arxHierarchyBuilderIntervalBased();
            this.applyIntervals(builder);
            this.applyLevels(builder);
            builder.prepare(column);
            return new Hierarchy(builder.build().getHierarchy());
        }
        if (this.dataType == BuilderDataType.DOUBLE) {
            HierarchyBuilderIntervalBased builder = this.arxHierarchyBuilderIntervalBasedDouble();
            this.applyIntervalsDouble(builder);
            this.applyLevels(builder);
            builder.prepare(column);
            return new Hierarchy(builder.build().getHierarchy());
        }
        throw new IllegalStateException("Datatype=" + this.dataType.toString() + " is not supported");
    }

    private HierarchyBuilderIntervalBased<Long> arxHierarchyBuilderIntervalBased() {
        HierarchyBuilderIntervalBased builder = this.upperRange == null || this.lowerRange == null ? HierarchyBuilderIntervalBased.create((DataType)DataType.INTEGER) : HierarchyBuilderIntervalBased.create((DataType)DataType.INTEGER, (HierarchyBuilderIntervalBased.Range)this.lowerRange.arxRangeLong(), (HierarchyBuilderIntervalBased.Range)this.upperRange.arxRangeLong());
        builder.setAggregateFunction(DataType.INTEGER.createAggregate().createIntervalFunction(true, false));
        return builder;
    }

    private HierarchyBuilderIntervalBased<Double> arxHierarchyBuilderIntervalBasedDouble() {
        HierarchyBuilderIntervalBased builder = this.upperRange == null || this.lowerRange == null ? HierarchyBuilderIntervalBased.create((DataType)DataType.DECIMAL) : HierarchyBuilderIntervalBased.create((DataType)DataType.DECIMAL, (HierarchyBuilderIntervalBased.Range)this.lowerRange.arxRangeDouble(), (HierarchyBuilderIntervalBased.Range)this.upperRange.arxRangeDouble());
        builder.setAggregateFunction(DataType.DECIMAL.createAggregate().createIntervalFunction(true, false));
        return builder;
    }

    private void applyIntervals(HierarchyBuilderIntervalBased<Long> builder) {
        if (this.intervals != null) {
            for (Interval interval : this.intervals) {
                interval.applyTo(builder);
            }
        }
    }

    private void applyIntervalsDouble(HierarchyBuilderIntervalBased<Double> builder) {
        if (this.intervals != null) {
            for (Interval interval : this.intervals) {
                interval.applyToDouble(builder);
            }
        }
    }

    private void applyLevels(HierarchyBuilderIntervalBased builder) {
        if (this.levels != null) {
            for (Level level : this.levels) {
                level.applyTo((HierarchyBuilderGroupingBased)builder);
            }
        }
    }

    public String toString() {
        return "IntervalBasedHierarchyBuilder{intervals=" + this.intervals + ", levels=" + this.levels + ", lowerRange=" + this.lowerRange + ", upperRange=" + this.upperRange + "}";
    }

    public List<Interval> getIntervals() {
        return this.intervals;
    }

    public List<Level> getLevels() {
        return this.levels;
    }

    public Range getLowerRange() {
        return this.lowerRange;
    }

    public Range getUpperRange() {
        return this.upperRange;
    }

    public BuilderDataType getDataType() {
        return this.dataType;
    }
}

