/*
 * Decompiled with CFR 0.152.
 */
package no.oslomet.aaas.model.risk;

import com.fasterxml.jackson.annotation.JsonCreator;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import no.oslomet.aaas.model.risk.AttackerSuccess;
import org.deidentifier.arx.ARXPopulationModel;
import org.deidentifier.arx.DataHandle;
import org.deidentifier.arx.risk.RiskEstimateBuilder;
import org.deidentifier.arx.risk.RiskModelPopulationUniqueness;
import org.deidentifier.arx.risk.RiskModelSampleRiskDistribution;
import org.deidentifier.arx.risk.RiskModelSampleRisks;
import org.deidentifier.arx.risk.RiskModelSampleSummary;
import org.deidentifier.arx.risk.RiskModelSampleUniqueness;

/*
 * Exception performing whole class analysis ignored.
 */
public class ReIdentificationRisk {
    private static final double THRESHOLD = 0.5;
    private final Map<String, Double> measures;
    private final AttackerSuccess attackerSuccessRate;
    private final List<String> quasiIdentifiers;
    private final String populationModel;

    @JsonCreator
    public ReIdentificationRisk(Map<String, Double> measures, AttackerSuccess attackerSuccessRate, List<String> quasiIdentifiers, String populationModel) {
        this.measures = measures;
        this.attackerSuccessRate = attackerSuccessRate;
        this.quasiIdentifiers = quasiIdentifiers;
        this.populationModel = populationModel;
    }

    public static ReIdentificationRisk create(DataHandle data, ARXPopulationModel pModel) {
        RiskEstimateBuilder riskEstimateBuilder = data.getRiskEstimator(pModel);
        Map riskMeasures = ReIdentificationRisk.riskMeasures((DataHandle)data, (ARXPopulationModel)pModel);
        AttackerSuccess attackerSuccess = AttackerSuccess.create((RiskModelSampleSummary)data.getRiskEstimator(pModel).getSampleBasedRiskSummary(0.5));
        List quasiIdentifiers = ReIdentificationRisk.quasiIdentifiers((DataHandle)data);
        String populationModel = ReIdentificationRisk.populationUniquenessModel((RiskEstimateBuilder)riskEstimateBuilder).toString();
        return new ReIdentificationRisk(riskMeasures, attackerSuccess, quasiIdentifiers, populationModel);
    }

    private static Map<String, Double> riskMeasures(DataHandle data, ARXPopulationModel pModel) {
        RiskEstimateBuilder riskEstimateBuilder = data.getRiskEstimator(pModel);
        RiskModelSampleRisks sampleRisks = riskEstimateBuilder.getSampleBasedReidentificationRisk();
        RiskModelSampleRiskDistribution sampleRiskDistribution = riskEstimateBuilder.getSampleBasedRiskDistribution();
        RiskModelSampleSummary riskModelSampleSummary = data.getRiskEstimator(pModel).getSampleBasedRiskSummary(0.5);
        double lowestRisk = ReIdentificationRisk.lowestProsecutorRisk((RiskModelSampleRisks)sampleRisks);
        double highestRisk = ReIdentificationRisk.highestProsecutorRisk((RiskModelSampleRisks)sampleRisks);
        double highestJournalistRisk = ReIdentificationRisk.highestJournalistRisk((RiskModelSampleSummary)riskModelSampleSummary);
        HashMap<String, Double> metricsMap = new HashMap<String, Double>();
        metricsMap.put("lowest_risk", lowestRisk);
        metricsMap.put("records_affected_by_lowest_risk", ReIdentificationRisk.recordsAffectByRisk((RiskModelSampleRiskDistribution)sampleRiskDistribution, (double)lowestRisk));
        metricsMap.put("average_prosecutor_risk", ReIdentificationRisk.averageProsecutorRisk((RiskModelSampleRisks)sampleRisks));
        metricsMap.put("highest_prosecutor_risk", highestRisk);
        metricsMap.put("records_affected_by_highest_prosecutor_risk", ReIdentificationRisk.recordsAffectByRisk((RiskModelSampleRiskDistribution)sampleRiskDistribution, (double)highestRisk));
        metricsMap.put("highest_journalist_risk", highestJournalistRisk);
        metricsMap.put("records_affected_by_highest_journalist_risk", ReIdentificationRisk.recordsAffectByRisk((RiskModelSampleRiskDistribution)sampleRiskDistribution, (double)highestJournalistRisk));
        metricsMap.put("estimated_prosecutor_risk", ReIdentificationRisk.estimatedProsecutorRisk((RiskModelSampleRisks)sampleRisks));
        metricsMap.put("estimated_journalist_risk", ReIdentificationRisk.estimatedJournalistRisk((RiskModelSampleRisks)sampleRisks));
        metricsMap.put("estimated_marketer_risk", ReIdentificationRisk.estimatedMarketerRisk((RiskModelSampleRisks)sampleRisks));
        metricsMap.put("sample_uniques", ReIdentificationRisk.sampleUniques((RiskModelSampleUniqueness)riskEstimateBuilder.getSampleBasedUniquenessRisk()));
        metricsMap.put("population_uniques", ReIdentificationRisk.populationUniques((RiskEstimateBuilder)riskEstimateBuilder));
        return metricsMap;
    }

    private static double lowestProsecutorRisk(RiskModelSampleRisks riskModelSampleRisks) {
        return riskModelSampleRisks.getLowestRisk();
    }

    private static double recordsAffectByRisk(RiskModelSampleRiskDistribution sampleRiskDistribution, double risk) {
        return sampleRiskDistribution.getFractionOfRecordsAtRisk(risk);
    }

    private static double averageProsecutorRisk(RiskModelSampleRisks riskModelSampleRisks) {
        return riskModelSampleRisks.getAverageRisk();
    }

    private static double highestProsecutorRisk(RiskModelSampleRisks riskModelSampleRisks) {
        return riskModelSampleRisks.getHighestRisk();
    }

    private static double estimatedProsecutorRisk(RiskModelSampleRisks riskModelSampleRisks) {
        return riskModelSampleRisks.getEstimatedProsecutorRisk();
    }

    private static double highestJournalistRisk(RiskModelSampleSummary riskModelSampleSummary) {
        return riskModelSampleSummary.getJournalistRisk().getHighestRisk();
    }

    private static double estimatedJournalistRisk(RiskModelSampleRisks riskModelSampleRisks) {
        return riskModelSampleRisks.getEstimatedJournalistRisk();
    }

    private static double estimatedMarketerRisk(RiskModelSampleRisks riskModelSampleRisks) {
        return riskModelSampleRisks.getEstimatedMarketerRisk();
    }

    private static double sampleUniques(RiskModelSampleUniqueness riskModelSampleUniqueness) {
        return riskModelSampleUniqueness.getFractionOfUniqueTuples();
    }

    private static double populationUniques(RiskEstimateBuilder builder) {
        return builder.getPopulationBasedUniquenessRisk().getFractionOfUniqueTuples(ReIdentificationRisk.populationUniquenessModel((RiskEstimateBuilder)builder));
    }

    private static RiskModelPopulationUniqueness.PopulationUniquenessModel populationUniquenessModel(RiskEstimateBuilder builder) {
        RiskModelPopulationUniqueness populationBasedUniquenessRisk = builder.getPopulationBasedUniquenessRisk();
        return populationBasedUniquenessRisk.getPopulationUniquenessModel();
    }

    private static List<String> quasiIdentifiers(DataHandle data) {
        return new ArrayList<String>(data.getDefinition().getQuasiIdentifyingAttributes());
    }

    public String toString() {
        return "ReIdentificationRisk{measures=" + this.measures + "}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ReIdentificationRisk that = (ReIdentificationRisk)o;
        return this.hashCode() == that.hashCode();
    }

    public int hashCode() {
        return Objects.hash(this.measures);
    }

    public AttackerSuccess getAttackerSuccessRate() {
        return this.attackerSuccessRate;
    }

    public List<String> getQuasiIdentifiers() {
        return this.quasiIdentifiers;
    }

    public String getPopulationModel() {
        return this.populationModel;
    }

    public Map<String, Double> getMeasures() {
        return this.measures;
    }
}

